/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import org.apache.any23.cli.BaseTool;
import org.apache.any23.http.DefaultHTTPClient;
import org.apache.any23.http.DefaultHTTPClientConfiguration;
import org.apache.any23.http.HTTPClient;
import org.apache.any23.http.HTTPClientConfiguration;
import org.apache.any23.mime.MIMEType;
import org.apache.any23.mime.TikaMIMETypeDetector;
import org.apache.any23.source.DocumentSource;
import org.apache.any23.source.FileDocumentSource;
import org.apache.any23.source.HTTPDocumentSource;
import org.apache.any23.source.StringDocumentSource;

@Parameters(commandNames={"mimes"}, commandDescription="MIME Type Detector Tool.")
public class MimeDetector
extends BaseTool {
    public static final String FILE_DOCUMENT_PREFIX = "file://";
    public static final String INLINE_DOCUMENT_PREFIX = "inline://";
    public static final String URL_DOCUMENT_RE = "^https?://.*";
    @Parameter(arity=1, description="Input document URL, {http://path/to/resource.html|file:///path/to/local.file|inline:// some inline content}", converter=MimeDetectorDocumentSourceConverter.class)
    private List<DocumentSource> document = new LinkedList<DocumentSource>();
    private PrintStream out = System.out;

    @Override
    PrintStream getOut() {
        return this.out;
    }

    @Override
    void setOut(PrintStream out) {
        this.out = out;
    }

    public void run() throws Exception {
        if (this.document.isEmpty()) {
            throw new IllegalArgumentException("No input document URL specified");
        }
        DocumentSource documentSource = this.document.get(0);
        TikaMIMETypeDetector detector = new TikaMIMETypeDetector();
        MIMEType mimeType = detector.guessMIMEType(documentSource.getDocumentIRI(), documentSource.openInputStream(), MIMEType.parse((String)documentSource.getContentType()));
        this.out.println(mimeType);
    }

    public static final class MimeDetectorDocumentSourceConverter
    implements IStringConverter<DocumentSource> {
        public DocumentSource convert(String document) {
            if (document.startsWith(MimeDetector.FILE_DOCUMENT_PREFIX)) {
                return new FileDocumentSource(new File(document.substring(MimeDetector.FILE_DOCUMENT_PREFIX.length())));
            }
            if (document.startsWith(MimeDetector.INLINE_DOCUMENT_PREFIX)) {
                return new StringDocumentSource(document.substring(MimeDetector.INLINE_DOCUMENT_PREFIX.length()), "");
            }
            if (document.matches(MimeDetector.URL_DOCUMENT_RE)) {
                DefaultHTTPClient client = new DefaultHTTPClient();
                client.init((HTTPClientConfiguration)DefaultHTTPClientConfiguration.singleton());
                try {
                    return new HTTPDocumentSource((HTTPClient)client, document);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid source IRI: '" + document + "'");
                }
            }
            throw new IllegalArgumentException("Unsupported protocol for document " + document);
        }
    }
}

