/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractDoubleCollection;
import com.carrotsearch.hppcrt.AbstractIntCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IntArrays;
import com.carrotsearch.hppcrt.IntContainer;
import com.carrotsearch.hppcrt.IntDoubleAssociativeContainer;
import com.carrotsearch.hppcrt.IntDoubleMap;
import com.carrotsearch.hppcrt.IntLookupContainer;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.DoubleCursor;
import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.cursors.IntDoubleCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.DoublePredicate;
import com.carrotsearch.hppcrt.predicates.IntDoublePredicate;
import com.carrotsearch.hppcrt.predicates.IntPredicate;
import com.carrotsearch.hppcrt.procedures.DoubleProcedure;
import com.carrotsearch.hppcrt.procedures.IntDoubleProcedure;
import com.carrotsearch.hppcrt.procedures.IntProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntDoubleHashMap
implements IntDoubleMap,
Cloneable {
    protected double defaultValue = 0.0;
    public int[] keys;
    public double[] values;
    public boolean allocatedDefaultKey = false;
    public double allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<IntDoubleCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = IntDoubleHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public IntDoubleHashMap() {
        this(8);
    }

    public IntDoubleHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public IntDoubleHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public IntDoubleHashMap(IntDoubleAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public double put(int key, double value) {
        int existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                double previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                double oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(IntDoubleAssociativeContainer container) {
        return this.putAll((Iterable<? extends IntDoubleCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends IntDoubleCursor> iterable) {
        int count = this.size();
        for (IntDoubleCursor intDoubleCursor : iterable) {
            this.put(intDoubleCursor.key, intDoubleCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(int key, double value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public double putOrAdd(int key, double putValue, double incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public double addTo(int key, double incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(int pendingKey, double pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0);
        int[] oldKeys = this.keys;
        double[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        int key = 0;
        double value = 0.0;
        int slot = -1;
        int[] keys = this.keys;
        double[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            int[] keys = new int[capacity];
            double[] values = new double[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public double remove(int key) {
        int existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                double previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                double value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        double[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            int existing = keys[slot];
            double existingValue = values[slot];
            if (existing == 0) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        --this.assigned;
    }

    @Override
    public int removeAll(IntContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof IntLookupContainer) {
            if (this.allocatedDefaultKey && other.contains(0)) {
                this.allocatedDefaultKey = false;
            }
            int[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                int existing = keys[i];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (IntCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0)) {
            this.allocatedDefaultKey = false;
        }
        int[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            int existing = keys[i];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(IntDoublePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        int[] keys = this.keys;
        double[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            int existing = keys[i];
            if (existing != 0 && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public double get(int key) {
        int existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(int key) {
        int existing;
        if (key == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        IntArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = 0;
        if (this.allocatedDefaultKey) {
            h += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        int[] keys = this.keys;
        double[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            int existing = keys[i];
            if (existing == 0) continue;
            h += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            IntDoubleHashMap other = (IntDoubleHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                IntDoubleCursor c = (IntDoubleCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                double otherValue = other.get(c.key);
                if (Double.doubleToLongBits(c.value) == Double.doubleToLongBits(otherValue)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends IntDoubleProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0, this.allocatedDefaultKeyValue);
        }
        int[] keys = this.keys;
        double[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int existing = keys[i];
            if (existing == 0) continue;
            procedure.apply(existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends IntDoublePredicate> T forEach(T predicate) {
        int existing;
        if (this.allocatedDefaultKey && !predicate.apply(0, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        int[] keys = this.keys;
        double[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing, values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public IntDoubleHashMap clone() {
        IntDoubleHashMap cloned = new IntDoubleHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntDoubleCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static IntDoubleHashMap from(int[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntDoubleHashMap map = new IntDoubleHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static IntDoubleHashMap from(IntDoubleAssociativeContainer container) {
        return new IntDoubleHashMap(container);
    }

    public static IntDoubleHashMap newInstance() {
        return new IntDoubleHashMap();
    }

    public static IntDoubleHashMap newInstance(int initialCapacity, double loadFactor) {
        return new IntDoubleHashMap(initialCapacity, loadFactor);
    }

    @Override
    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        public final DoubleCursor cursor = new DoubleCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            if (this.cursor.index == IntDoubleHashMap.this.values.length + 1) {
                if (IntDoubleHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = IntDoubleHashMap.this.values.length;
                    this.cursor.value = IntDoubleHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = IntDoubleHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && IntDoubleHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = IntDoubleHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractDoubleCollection {
        private final IntDoubleHashMap owner;
        protected final IteratorPool<DoubleCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = IntDoubleHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = IntDoubleHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(double value) {
            if (this.owner.allocatedDefaultKey && Double.doubleToLongBits(value) == Double.doubleToLongBits(this.owner.allocatedDefaultKeyValue)) {
                return true;
            }
            int[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == 0 || Double.doubleToLongBits(value) != Double.doubleToLongBits(values[slot])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            int[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == 0) continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            int[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (keys[slot] == 0 || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(double e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && Double.doubleToLongBits(e) == Double.doubleToLongBits(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            int[] keys = this.owner.keys;
            double[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != 0 && Double.doubleToLongBits(e) == Double.doubleToLongBits(values[slot])) {
                    IntDoubleHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            int[] keys = this.owner.keys;
            double[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != 0 && predicate.apply(values[slot])) {
                    IntDoubleHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public double[] toArray(double[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            int[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (keys[i] == 0) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            if (this.cursor.index == IntDoubleHashMap.this.keys.length + 1) {
                if (IntDoubleHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = IntDoubleHashMap.this.keys.length;
                    this.cursor.value = 0;
                    return this.cursor;
                }
                this.cursor.index = IntDoubleHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && IntDoubleHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = IntDoubleHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntDoubleHashMap owner;
        protected final IteratorPool<IntCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = IntDoubleHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = IntDoubleHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(int e) {
            return IntDoubleHashMap.this.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(0);
            }
            int[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                int existing = keys[i];
                if (existing == 0) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            int existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(0)) {
                return predicate;
            }
            int[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(int e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public int[] toArray(int[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0;
            }
            int[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                int existing = keys[i];
                if (existing == 0) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<IntDoubleCursor> {
        public final IntDoubleCursor cursor = new IntDoubleCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected IntDoubleCursor fetch() {
            int i;
            if (this.cursor.index == IntDoubleHashMap.this.keys.length + 1) {
                if (IntDoubleHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = IntDoubleHashMap.this.keys.length;
                    this.cursor.key = 0;
                    this.cursor.value = IntDoubleHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = IntDoubleHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && IntDoubleHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (IntDoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = IntDoubleHashMap.this.keys[i];
            this.cursor.value = IntDoubleHashMap.this.values[i];
            return this.cursor;
        }
    }
}

