/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.mdat;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public final class MediaDataBox
implements Box {
    public static final String TYPE = "mdat";
    Container parent;
    private DataSource dataSource;
    private long offset;
    private long size;

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    public String getType() {
        return TYPE;
    }

    private static void transfer(DataSource from, long position, long count, WritableByteChannel to) throws IOException {
        long maxCount = 67076096L;
        long offset = 0L;
        while (offset < count) {
            offset += from.transferTo(position + offset, Math.min(maxCount, count - offset), to);
        }
    }

    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        MediaDataBox.transfer(this.dataSource, this.offset, this.size, writableByteChannel);
    }

    public long getSize() {
        return this.size;
    }

    public long getOffset() {
        return this.offset;
    }

    public void parse(DataSource dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        this.offset = dataSource.position() - (long)header.remaining();
        this.dataSource = dataSource;
        this.size = contentSize + (long)header.remaining();
        dataSource.position(dataSource.position() + contentSize);
    }

    public String toString() {
        return "MediaDataBox{size=" + this.size + '}';
    }
}

