/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import java.util.Locale;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleHandlerException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;

public class RepositoryWriter
implements TripleHandler {
    private final RepositoryConnection conn;
    private final Resource overrideContext;

    public RepositoryWriter(RepositoryConnection conn) {
        this(conn, null);
    }

    public RepositoryWriter(RepositoryConnection conn, Resource overrideContext) {
        this.conn = conn;
        this.overrideContext = overrideContext;
    }

    public void startDocument(IRI documentIRI) throws TripleHandlerException {
    }

    public void openContext(ExtractionContext context) throws TripleHandlerException {
    }

    public void receiveTriple(Resource s, IRI p, Value o, IRI g, ExtractionContext context) throws TripleHandlerException {
        try {
            this.conn.add(this.conn.getValueFactory().createStatement(s, p, o, (Resource)g), new Resource[]{this.getContextResource((Resource)context.getDocumentIRI())});
        }
        catch (RepositoryException ex) {
            throw new TripleHandlerException(String.format(Locale.ROOT, "Error while receiving triple: %s %s %s", s, p, o), (Exception)((Object)ex));
        }
    }

    public void receiveNamespace(String prefix, String uri, ExtractionContext context) throws TripleHandlerException {
        try {
            this.conn.setNamespace(prefix, uri);
        }
        catch (RepositoryException ex) {
            throw new TripleHandlerException(String.format(Locale.ROOT, "Error while receiving namespace: %s:%s", prefix, uri), (Exception)((Object)ex));
        }
    }

    public void closeContext(ExtractionContext context) throws TripleHandlerException {
    }

    public void close() throws TripleHandlerException {
    }

    public void endDocument(IRI documentIRI) throws TripleHandlerException {
    }

    public void setContentLength(long contentLength) {
    }

    private Resource getContextResource(Resource fromExtractor) {
        if (this.overrideContext != null) {
            return this.overrideContext;
        }
        return fromExtractor;
    }
}

