/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import java.io.BufferedWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Optional;
import org.apache.any23.configuration.Settings;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.writer.FormatWriter;
import org.apache.any23.writer.TripleFormat;
import org.apache.any23.writer.TripleHandlerException;
import org.apache.any23.writer.TripleWriterHandler;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.WriterConfig;

public abstract class RDFWriterTripleHandler
extends TripleWriterHandler
implements FormatWriter {
    private RDFWriter _writer;
    private boolean writerStarted;
    private final Flushable out;
    private final TripleFormat format;
    private boolean annotated = false;

    static TripleFormat format(RDFWriterFactory rdf4j) {
        return TripleFormat.of((RDFFormat)rdf4j.getRDFFormat());
    }

    RDFWriterTripleHandler(RDFWriterFactory rdf4j, TripleFormat format, OutputStream out, Settings settings) {
        RDFWriter w;
        this.format = format;
        Optional charset = format.getCharset();
        if (!charset.isPresent()) {
            this.out = out;
            w = this._writer = rdf4j.getWriter(out);
        } else {
            BufferedWriter buf = new BufferedWriter(new OutputStreamWriter(out, (Charset)charset.get()));
            this.out = buf;
            w = this._writer = rdf4j.getWriter((Writer)buf);
        }
        this.configure(w.getWriterConfig(), settings);
    }

    abstract void configure(WriterConfig var1, Settings var2);

    RDFWriter writer() throws TripleHandlerException {
        RDFWriter w = this._writer;
        if (w == null) {
            throw new TripleHandlerException("writer has been closed!");
        }
        if (!this.writerStarted) {
            this.writerStarted = true;
            try {
                w.startRDF();
            }
            catch (RDFHandlerException e) {
                throw new TripleHandlerException("Error while starting document", (Exception)((Object)e));
            }
        }
        return w;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public void setAnnotated(boolean f) {
        this.annotated = f;
    }

    @Override
    public void startDocument(IRI documentIRI) throws TripleHandlerException {
        this.handleComment("OUTPUT FORMAT: " + this.format);
    }

    @Override
    public void openContext(ExtractionContext context) throws TripleHandlerException {
        this.handleComment("BEGIN: " + context);
    }

    public void writeTriple(Resource s, IRI p, Value o, Resource g) throws TripleHandlerException {
        try {
            this.writer().handleStatement(RDFUtils.quad(s, p, o, g));
        }
        catch (RDFHandlerException ex) {
            throw new TripleHandlerException(String.format(Locale.ROOT, "Error while receiving triple: %s %s %s %s", s, p, o, g), (Exception)((Object)ex));
        }
    }

    public void writeNamespace(String prefix, String uri) throws TripleHandlerException {
        try {
            this.writer().handleNamespace(prefix, uri);
        }
        catch (RDFHandlerException ex) {
            throw new TripleHandlerException(String.format(Locale.ROOT, "Error while receiving namespace: %s:%s", prefix, uri), (Exception)((Object)ex));
        }
    }

    @Override
    public void closeContext(ExtractionContext context) throws TripleHandlerException {
        this.handleComment("END: " + context);
    }

    public void close() throws TripleHandlerException {
        RDFWriter writer = this._writer;
        if (writer == null) {
            return;
        }
        this._writer = null;
        try {
            if (!this.writerStarted) {
                writer.startRDF();
            }
            writer.endRDF();
        }
        catch (RDFHandlerException e) {
            throw new TripleHandlerException("Error closing writer", (Exception)((Object)e));
        }
    }

    @Override
    public void endDocument(IRI documentIRI) throws TripleHandlerException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new TripleHandlerException("Error ending document", (Exception)e);
        }
    }

    private void handleComment(String comment) throws TripleHandlerException {
        if (!this.annotated) {
            return;
        }
        try {
            this.writer().handleComment(comment);
        }
        catch (RDFHandlerException rdfhe) {
            throw new TripleHandlerException("Error while handing comment.", (Exception)((Object)rdfhe));
        }
    }
}

