/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.any23.writer.FormatWriter;
import org.apache.any23.writer.TripleHandlerException;
import org.apache.any23.writer.TripleWriterHandler;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

@Deprecated
public class JSONWriter
extends TripleWriterHandler
implements FormatWriter {
    private JsonGenerator ps;
    private boolean documentStarted = false;

    public JSONWriter(OutputStream os) {
        if (os == null) {
            throw new NullPointerException("Output stream cannot be null.");
        }
        JsonFactory factory = new JsonFactory();
        try {
            this.ps = factory.createGenerator(os).disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET).enable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM).setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void start(boolean throwIfStarted) throws TripleHandlerException {
        if (this.documentStarted) {
            if (throwIfStarted) {
                throw new IllegalStateException("Document already started.");
            }
            return;
        }
        this.documentStarted = true;
        try {
            this.ps.writeStartObject();
            this.ps.writeFieldName("quads");
            this.ps.writeStartArray();
        }
        catch (IOException ex) {
            throw new TripleHandlerException("IO Error while starting document.", (Exception)ex);
        }
    }

    @Override
    public void startDocument(IRI documentIRI) throws TripleHandlerException {
        this.start(true);
    }

    public void writeTriple(Resource s, IRI p, Value o, Resource g) throws TripleHandlerException {
        this.start(false);
        try {
            this.ps.writeStartArray();
            if (s instanceof IRI) {
                this.printExplicitIRI(s.stringValue());
            } else {
                this.printBNode(s.stringValue());
            }
            this.printIRI(p.stringValue());
            if (o instanceof IRI) {
                this.printExplicitIRI(o.stringValue());
            } else if (o instanceof BNode) {
                this.printBNode(o.stringValue());
            } else {
                this.printLiteral((Literal)o);
            }
            this.printIRI(g == null ? null : g.stringValue());
            this.ps.writeEndArray();
        }
        catch (IOException ex) {
            throw new TripleHandlerException("IO Error while writing triple", (Exception)ex);
        }
    }

    public void writeNamespace(String prefix, String uri) throws TripleHandlerException {
    }

    @Override
    public void endDocument(IRI documentIRI) throws TripleHandlerException {
        this.validateDocumentStarted();
    }

    public void close() throws TripleHandlerException {
        this.start(false);
        try {
            this.ps.writeEndArray();
            this.ps.writeEndObject();
            this.ps.close();
        }
        catch (IOException ex) {
            throw new TripleHandlerException("IO Error while closing document.", (Exception)ex);
        }
        finally {
            this.ps = null;
        }
    }

    private void validateDocumentStarted() {
        if (!this.documentStarted) {
            throw new IllegalStateException("Document didn't start.");
        }
    }

    private void printIRI(String uri) throws IOException {
        this.printValue(uri);
    }

    private void printExplicitIRI(String uri) throws IOException {
        this.printValue("uri", uri);
    }

    private void printBNode(String bnode) throws IOException {
        this.printValue("bnode", bnode);
    }

    private void printLiteral(Literal literal) throws IOException {
        this.ps.writeStartObject();
        this.ps.writeStringField("type", "literal");
        this.ps.writeStringField("value", literal.stringValue());
        Optional language = literal.getLanguage();
        this.ps.writeStringField("lang", language.isPresent() ? (String)literal.getLanguage().get() : null);
        IRI datatype = literal.getDatatype();
        this.ps.writeStringField("datatype", datatype != null ? datatype.stringValue() : null);
        this.ps.writeEndObject();
    }

    private void printValue(String type, String value) throws IOException {
        this.ps.writeStartObject();
        this.ps.writeStringField("type", type);
        this.ps.writeStringField("value", value);
        this.ps.writeEndObject();
    }

    private void printValue(String value) throws IOException {
        this.ps.writeString(value);
    }

    public boolean isAnnotated() {
        return false;
    }

    public void setAnnotated(boolean f) {
    }
}

