/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.filter;

import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.filter.ExtractionContextBlocker;
import org.apache.any23.vocab.XHTML;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleHandlerException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class IgnoreAccidentalRDFa
implements TripleHandler {
    private static final XHTML vXHTML = XHTML.getInstance();
    private final ExtractionContextBlocker blocker;
    private final boolean alwaysSuppressCSSTriples;

    public IgnoreAccidentalRDFa(TripleHandler wrapped, boolean alwaysSuppressCSSTriples) {
        this.blocker = new ExtractionContextBlocker(wrapped);
        this.alwaysSuppressCSSTriples = alwaysSuppressCSSTriples;
    }

    public IgnoreAccidentalRDFa(TripleHandler wrapped) {
        this(wrapped, false);
    }

    public void startDocument(IRI documentIRI) throws TripleHandlerException {
        this.blocker.startDocument(documentIRI);
    }

    public void openContext(ExtractionContext context) throws TripleHandlerException {
        this.blocker.openContext(context);
        if (this.isRDFaContext(context)) {
            this.blocker.blockContext(context);
        }
    }

    public void receiveTriple(Resource s, IRI p, Value o, IRI g, ExtractionContext context) throws TripleHandlerException {
        if (this.alwaysSuppressCSSTriples && p.stringValue().equals(IgnoreAccidentalRDFa.vXHTML.stylesheet.stringValue())) {
            return;
        }
        if (this.isRDFaContext(context)) {
            this.blocker.unblockContext(context);
        }
        this.blocker.receiveTriple(s, p, o, g, context);
    }

    public void receiveNamespace(String prefix, String uri, ExtractionContext context) throws TripleHandlerException {
        this.blocker.receiveNamespace(prefix, uri, context);
    }

    public void closeContext(ExtractionContext context) {
        this.blocker.closeContext(context);
    }

    public void close() throws TripleHandlerException {
        this.blocker.close();
    }

    private boolean isRDFaContext(ExtractionContext context) {
        return context.getExtractorName().equals("html-rdfa");
    }

    public void endDocument(IRI documentIRI) throws TripleHandlerException {
        this.blocker.endDocument(documentIRI);
    }

    public void setContentLength(long contentLength) {
    }
}

