/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.yaml;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.vocab.YAML;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModelFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;

public class ElementsProcessor {
    private final ModelFactory modelFactory = new LinkedHashModelFactory();
    private final YAML vocab = YAML.getInstance();
    protected ValueFactory vf = SimpleValueFactory.getInstance();
    private static final ElementsProcessor _ep = new ElementsProcessor();

    private ElementsProcessor() {
    }

    private ModelHolder asModelHolder(Value v, Model m) {
        return new ModelHolder(v, m);
    }

    public ModelHolder asModel(IRI namespace, Object t, Value rootNode) {
        if (t instanceof List) {
            return this.processList(namespace, (List)t);
        }
        if (t instanceof Map) {
            return this.processMap(namespace, (Map)t, rootNode);
        }
        if (t instanceof String) {
            return this.asModelHolder(RDFUtils.makeIRI(t.toString()), this.modelFactory.createEmptyModel());
        }
        if (t == null) {
            return this.asModelHolder((Value)this.vocab.nullValue, this.modelFactory.createEmptyModel());
        }
        return this.asModelHolder((Value)Literals.createLiteral((ValueFactory)this.vf, (Object)t), this.modelFactory.createEmptyModel());
    }

    protected ModelHolder processMap(IRI ns, Map<String, Object> object, Value parentNode) {
        Value nodeURI;
        if (object.isEmpty()) {
            return null;
        }
        HashSet vals = Sets.newHashSet(object.values());
        boolean isEmpty = false;
        if (vals.size() == 1 && vals.contains(null)) {
            isEmpty = true;
        }
        assert (ns != null) : "Namespace value is null";
        Model model = this.modelFactory.createEmptyModel();
        Object object2 = nodeURI = parentNode instanceof BNode ? RDFUtils.makeIRI("node", ns, true) : parentNode;
        if (!isEmpty) {
            model.add((Object)this.vf.createStatement((Resource)nodeURI, RDF.TYPE, (Value)this.vocab.mapping));
        }
        object.keySet().forEach(k -> {
            Resource predicate = RDFUtils.makeIRI(k, ns, false);
            model.add((Object)this.vf.createStatement(predicate, RDF.TYPE, (Value)RDF.PREDICATE));
            model.add((Object)this.vf.createStatement(predicate, RDFS.LABEL, (Value)RDFUtils.literal(k)));
            Value subGraphRoot = RDFUtils.makeIRI();
            ModelHolder valInst = this.asModel(ns, object.get(k), subGraphRoot);
            if (valInst != null) {
                model.add((Object)this.vf.createStatement((Resource)nodeURI, (IRI)predicate, valInst.root));
                if (valInst.model != null) {
                    model.addAll((Collection)valInst.model);
                }
            }
        });
        return this.asModelHolder(nodeURI, model);
    }

    protected ModelHolder processList(IRI ns, List<Object> object) {
        if (object.isEmpty() || object.stream().noneMatch(i -> i != null)) {
            return null;
        }
        assert (ns != null) : "Namespace value is null";
        int objectSize = object.size();
        BNode listRoot = null;
        BNode prevNode = null;
        Model finalModel = this.modelFactory.createEmptyModel();
        for (int i2 = 0; i2 < objectSize; ++i2) {
            ModelHolder node = this.asModel(ns, object.get(i2), (Value)RDFUtils.bnode());
            BNode currentNode = RDFUtils.bnode();
            if (i2 == 0) {
                listRoot = currentNode;
            }
            finalModel.add((Resource)currentNode, RDF.FIRST, node.root, (Resource[])null);
            if (prevNode != null) {
                finalModel.add(prevNode, RDF.REST, (Value)currentNode, (Resource[])null);
            }
            if (i2 == objectSize - 1) {
                finalModel.add((Resource)currentNode, RDF.REST, (Value)RDF.NIL, (Resource[])null);
            }
            if (node.model != null) {
                finalModel.addAll((Collection)node.model);
            }
            prevNode = currentNode;
        }
        return this.asModelHolder((Value)listRoot, finalModel);
    }

    public static final ElementsProcessor getInstance() {
        return _ep;
    }

    public static class ModelHolder {
        private final Value root;
        private final Model model;

        public ModelHolder(Value root, Model model) {
            this.root = root;
            this.model = model;
        }

        public Value getRoot() {
            return this.root;
        }

        public Model getModel() {
            return this.model;
        }
    }
}

