/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.io.IOException;
import java.io.InputStream;

public class SpanCloserInputStream
extends InputStream {
    private static final String TRAILING_SEQUENCE_OPEN = "<span";
    private static final char TRAILING_SEQUENCE_CLOSE = '>';
    private static final String CLOSE_SEQUENCE = "</span>";
    private final InputStream wrapped;
    private int trailingSequenceOpenMatch = 0;
    private int closeSequenceIndex = 0;
    private boolean trailingSequenceOpenDetected = false;
    private boolean trailingSequenceCloseDetected = false;
    private boolean inlineDetected = false;
    private boolean betweenQuotes = false;

    public SpanCloserInputStream(InputStream is) {
        this.wrapped = is;
    }

    @Override
    public int read() throws IOException {
        int c;
        if (this.trailingSequenceOpenDetected && this.inlineDetected && this.trailingSequenceCloseDetected) {
            char ret = CLOSE_SEQUENCE.charAt(this.closeSequenceIndex);
            ++this.closeSequenceIndex;
            if (this.closeSequenceIndex >= CLOSE_SEQUENCE.length()) {
                this.resetDetector();
            }
            return ret;
        }
        if (this.trailingSequenceOpenDetected && this.trailingSequenceCloseDetected) {
            this.resetDetector();
        }
        if ((c = this.wrapped.read()) == 34) {
            this.betweenQuotes = !this.betweenQuotes;
        } else if (c == 47 && !this.betweenQuotes && this.trailingSequenceOpenDetected && !this.trailingSequenceCloseDetected) {
            this.inlineDetected = true;
            c = this.wrapped.read();
        }
        if (!this.trailingSequenceOpenDetected && this.checkOpenTrailingSequence(c)) {
            this.trailingSequenceOpenDetected = true;
            this.trailingSequenceCloseDetected = false;
        } else if (c == 62 && this.trailingSequenceOpenDetected) {
            this.trailingSequenceCloseDetected = true;
        }
        return c;
    }

    private boolean checkOpenTrailingSequence(int c) {
        if (TRAILING_SEQUENCE_OPEN.charAt(this.trailingSequenceOpenMatch) == Character.toLowerCase(c)) {
            ++this.trailingSequenceOpenMatch;
            if (this.trailingSequenceOpenMatch == TRAILING_SEQUENCE_OPEN.length()) {
                this.trailingSequenceOpenMatch = 0;
                return true;
            }
        } else {
            this.trailingSequenceOpenMatch = 0;
        }
        return false;
    }

    private void resetDetector() {
        this.trailingSequenceOpenMatch = 0;
        this.closeSequenceIndex = 0;
        this.trailingSequenceOpenDetected = false;
        this.trailingSequenceCloseDetected = false;
        this.inlineDetected = false;
        this.betweenQuotes = false;
    }
}

