/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.any23.configuration.DefaultConfiguration;
import org.apache.any23.extractor.ExtractorFactory;
import org.apache.any23.extractor.ExtractorGroup;
import org.apache.any23.extractor.ExtractorRegistry;
import org.eclipse.rdf4j.common.lang.service.ServiceRegistry;

public class ExtractorRegistryImpl
extends ServiceRegistry<String, ExtractorFactory>
implements ExtractorRegistry {
    private static ExtractorRegistry instance = null;

    public ExtractorRegistryImpl() {
        super(ExtractorFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtractorRegistry getInstance() {
        Class<ExtractorRegistry> clazz = ExtractorRegistry.class;
        synchronized (ExtractorRegistry.class) {
            DefaultConfiguration conf = DefaultConfiguration.singleton();
            if (instance == null) {
                instance = new ExtractorRegistryImpl();
                if (conf.getFlagProperty("any23.extraction.rdfa.programmatic")) {
                    instance.unregister("html-rdfa");
                } else {
                    instance.unregister("html-rdfa11");
                }
                if (!conf.getFlagProperty("any23.extraction.head.meta")) {
                    instance.unregister("html-head-meta");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void register(ExtractorFactory<?> factory) {
        this.add(factory);
    }

    public void unregister(String name) {
        if (this.has(name)) {
            this.remove((ExtractorFactory)this.get(name).get());
        }
    }

    public ExtractorFactory<?> getFactory(String name) {
        return (ExtractorFactory)this.get(name).orElseThrow(() -> new IllegalArgumentException("Unregistered extractor name: " + name));
    }

    public ExtractorGroup getExtractorGroup() {
        return this.getExtractorGroup(this.getAllNames());
    }

    public ExtractorGroup getExtractorGroup(List<String> names) {
        ArrayList members = new ArrayList(names.size());
        for (String name : names) {
            members.add(this.getFactory(name));
        }
        return new ExtractorGroup(members);
    }

    public boolean isRegisteredName(String name) {
        return this.has(name);
    }

    public List<String> getAllNames() {
        ArrayList<String> result = new ArrayList<String>(this.getKeys());
        Collections.sort(result);
        return result;
    }

    protected String getKey(ExtractorFactory service) {
        return service.getExtractorName();
    }
}

