/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import org.apache.any23.cli.BaseTool;
import org.apache.any23.vocab.RDFSchemaUtils;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.Rio;

@Parameters(commandNames={"vocab"}, commandDescription="Prints out the RDF Schema of the vocabularies used by Any23.")
public class VocabPrinter
extends BaseTool {
    @Parameter(names={"-f", "--format"}, description="Vocabulary output format", converter=RDFFormatConverter.class)
    private RDFFormat format = RDFFormat.NQUADS;
    private PrintStream out = System.out;

    @Override
    PrintStream getOut() {
        return this.out;
    }

    @Override
    void setOut(PrintStream out) {
        this.out = out;
    }

    public void run() throws Exception {
        RDFSchemaUtils.serializeVocabularies((RDFFormat)this.format, (PrintStream)this.out);
    }

    public static final class RDFFormatConverter
    implements IStringConverter<RDFFormat> {
        public RDFFormat convert(String value) {
            return (RDFFormat)RDFWriterRegistry.getInstance().getFileFormatForMIMEType(value).orElseThrow(Rio.unsupportedFormat((String)value));
        }
    }
}

