/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.any23.cli.BaseTool;
import org.apache.any23.extractor.html.TagSoupParser;
import org.apache.any23.http.DefaultHTTPClient;
import org.apache.any23.http.HTTPClient;
import org.apache.any23.source.DocumentSource;
import org.apache.any23.source.FileDocumentSource;
import org.apache.any23.source.HTTPDocumentSource;
import org.apache.any23.util.StreamUtils;
import org.w3c.dom.Document;

@Parameters(commandNames={"microdata"}, commandDescription="Commandline Tool for extracting Microdata from file/HTTP source.")
public class MicrodataParser
extends BaseTool {
    private static final Pattern HTTP_DOCUMENT_PATTERN = Pattern.compile("^https?://.*");
    private static final Pattern FILE_DOCUMENT_PATTERN = Pattern.compile("^file:(.*)$");
    @Parameter(arity=1, description="Input document URL, {http://path/to/resource.html|file:/path/to/localFile.html}", converter=MicrodataParserDocumentSourceConverter.class)
    private List<DocumentSource> document = new LinkedList<DocumentSource>();
    private PrintStream out = System.out;

    @Override
    PrintStream getOut() {
        return this.out;
    }

    @Override
    void setOut(PrintStream out) {
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws Exception {
        if (this.document.isEmpty()) {
            throw new IllegalArgumentException("No input document URL specified");
        }
        InputStream documentInputInputStream = null;
        try {
            DocumentSource documentSource = this.document.get(0);
            documentInputInputStream = documentSource.openInputStream();
            TagSoupParser tagSoupParser = new TagSoupParser(documentInputInputStream, documentSource.getDocumentIRI());
            org.apache.any23.extractor.microdata.MicrodataParser.getMicrodataAsJSON((Document)tagSoupParser.getDOM(), (PrintStream)this.out);
            if (documentInputInputStream == null) return;
        }
        catch (Throwable throwable) {
            if (documentInputInputStream == null) throw throwable;
            StreamUtils.closeGracefully(documentInputInputStream);
            throw throwable;
        }
        StreamUtils.closeGracefully((Closeable)documentInputInputStream);
    }

    public static final class MicrodataParserDocumentSourceConverter
    implements IStringConverter<DocumentSource> {
        public DocumentSource convert(String value) {
            Matcher httpMatcher = HTTP_DOCUMENT_PATTERN.matcher(value);
            if (httpMatcher.find()) {
                try {
                    return new HTTPDocumentSource((HTTPClient)DefaultHTTPClient.createInitializedHTTPClient(), value);
                }
                catch (URISyntaxException e) {
                    throw new ParameterException("Invalid source IRI: '" + value + "'");
                }
            }
            Matcher fileMatcher = FILE_DOCUMENT_PATTERN.matcher(value);
            if (fileMatcher.find()) {
                return new FileDocumentSource(new File(fileMatcher.group(1)));
            }
            throw new ParameterException("Invalid source protocol: '" + value + "'");
        }
    }
}

