/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util.com.google.ical.iter;

import biweekly.util.com.google.ical.iter.DateValueComparison;
import biweekly.util.com.google.ical.iter.RecurrenceIterator;
import biweekly.util.com.google.ical.values.DateValue;
import java.util.Arrays;
import java.util.NoSuchElementException;

final class RDateIteratorImpl
implements RecurrenceIterator {
    private final DateValue[] datesUtc;
    private int i;

    RDateIteratorImpl(DateValue[] datesUtc) {
        datesUtc = (DateValue[])datesUtc.clone();
        Arrays.sort(datesUtc);
        this.datesUtc = RDateIteratorImpl.removeDuplicates(datesUtc);
    }

    public boolean hasNext() {
        return this.i < this.datesUtc.length;
    }

    public DateValue next() {
        if (this.i >= this.datesUtc.length) {
            throw new NoSuchElementException();
        }
        return this.datesUtc[this.i++];
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void advanceTo(DateValue newStartUtc) {
        long startCmp = DateValueComparison.comparable(newStartUtc);
        while (this.i < this.datesUtc.length && startCmp > DateValueComparison.comparable(this.datesUtc[this.i])) {
            ++this.i;
        }
    }

    private static DateValue[] removeDuplicates(DateValue[] dates) {
        int k = 0;
        for (int i = 1; i < dates.length; ++i) {
            if (dates[i].equals(dates[k])) continue;
            dates[++k] = dates[i];
        }
        if (++k < dates.length) {
            DateValue[] uniqueDates = new DateValue[k];
            System.arraycopy(dates, 0, uniqueDates, 0, k);
            return uniqueDates;
        }
        return dates;
    }
}

