/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util.com.google.ical.iter;

import biweekly.util.com.google.ical.iter.DateValueComparison;
import biweekly.util.com.google.ical.iter.HeapElement;
import biweekly.util.com.google.ical.iter.RecurrenceIterator;
import biweekly.util.com.google.ical.values.DateValue;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CompoundIteratorImpl
implements RecurrenceIterator {
    private final PriorityQueue<HeapElement> queue;
    private HeapElement pending;
    private int nInclusionsRemaining;

    CompoundIteratorImpl(Collection<RecurrenceIterator> inclusions, Collection<RecurrenceIterator> exclusions) {
        HeapElement el;
        this.queue = new PriorityQueue<HeapElement>(inclusions.size() + exclusions.size(), HeapElement.CMP);
        for (RecurrenceIterator it : inclusions) {
            el = new HeapElement(true, it);
            if (!el.shift()) continue;
            this.queue.add(el);
            ++this.nInclusionsRemaining;
        }
        for (RecurrenceIterator it : exclusions) {
            el = new HeapElement(false, it);
            if (!el.shift()) continue;
            this.queue.add(el);
        }
    }

    @Override
    public boolean hasNext() {
        this.requirePending();
        return this.pending != null;
    }

    @Override
    public DateValue next() {
        this.requirePending();
        if (this.pending == null) {
            throw new NoSuchElementException();
        }
        DateValue head = this.pending.head();
        this.reattach(this.pending);
        this.pending = null;
        return head;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void advanceTo(DateValue newStart) {
        long newStartCmp = DateValueComparison.comparable(newStart);
        if (this.pending != null) {
            if (this.pending.comparable() >= newStartCmp) {
                return;
            }
            this.pending.advanceTo(newStart);
            this.reattach(this.pending);
            this.pending = null;
        }
        while (this.nInclusionsRemaining != 0 && !this.queue.isEmpty() && this.queue.peek().comparable() < newStartCmp) {
            HeapElement el = this.queue.poll();
            el.advanceTo(newStart);
            this.reattach(el);
        }
    }

    private void reattach(HeapElement el) {
        if (el.shift()) {
            this.queue.add(el);
        } else if (el.inclusion && --this.nInclusionsRemaining == 0) {
            this.queue.clear();
        }
    }

    private void requirePending() {
        if (this.pending != null) {
            return;
        }
        long exclusionComparable = Long.MIN_VALUE;
        while (this.nInclusionsRemaining != 0 && !this.queue.isEmpty()) {
            boolean excluded;
            HeapElement inclusion = null;
            do {
                HeapElement candidate = this.queue.poll();
                if (candidate.inclusion) {
                    if (exclusionComparable != candidate.comparable()) {
                        inclusion = candidate;
                        break;
                    }
                } else {
                    exclusionComparable = candidate.comparable();
                }
                this.reattach(candidate);
                if (this.nInclusionsRemaining != 0) continue;
                return;
            } while (!this.queue.isEmpty());
            if (inclusion == null) {
                return;
            }
            long inclusionComparable = inclusion.comparable();
            boolean bl = excluded = exclusionComparable == inclusionComparable;
            while (!this.queue.isEmpty() && this.queue.peek().comparable() == inclusionComparable) {
                HeapElement match = this.queue.poll();
                excluded |= !match.inclusion;
                this.reattach(match);
                if (this.nInclusionsRemaining != 0) continue;
                return;
            }
            if (!excluded) {
                this.pending = inclusion;
                return;
            }
            this.reattach(inclusion);
        }
    }
}

