/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util.com.google.ical.compat.javautil;

import biweekly.util.com.google.ical.compat.javautil.DateIterable;
import biweekly.util.com.google.ical.compat.javautil.DateIterator;
import biweekly.util.com.google.ical.iter.RecurrenceIterable;
import biweekly.util.com.google.ical.iter.RecurrenceIterator;
import biweekly.util.com.google.ical.util.TimeUtils;
import biweekly.util.com.google.ical.values.DateTimeValueImpl;
import biweekly.util.com.google.ical.values.DateValue;
import biweekly.util.com.google.ical.values.DateValueImpl;
import biweekly.util.com.google.ical.values.TimeValue;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateIteratorFactory {
    public static DateIterator createDateIterator(RecurrenceIterator rit) {
        return new RecurrenceIteratorWrapper(rit);
    }

    public static DateIterable createDateIterable(RecurrenceIterable rit) {
        return new RecurrenceIterableWrapper(rit);
    }

    private DateIteratorFactory() {
    }

    private static final class RecurrenceIteratorWrapper
    implements DateIterator {
        private final RecurrenceIterator it;
        private final Calendar utcCalendar = new GregorianCalendar(TimeUtils.utcTimezone());

        public RecurrenceIteratorWrapper(RecurrenceIterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Date next() {
            return this.toDate(this.it.next());
        }

        public void advanceTo(Date d) {
            this.it.advanceTo(this.toDateValue(d));
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Date toDate(DateValue dateValue) {
            TimeValue time = TimeUtils.timeOf(dateValue);
            this.utcCalendar.clear();
            this.utcCalendar.set(dateValue.year(), dateValue.month() - 1, dateValue.day(), time.hour(), time.minute(), time.second());
            return this.utcCalendar.getTime();
        }

        private DateValue toDateValue(Date date) {
            this.utcCalendar.setTime(date);
            int year = this.utcCalendar.get(1);
            int month = this.utcCalendar.get(2) + 1;
            int day = this.utcCalendar.get(5);
            int hour = this.utcCalendar.get(11);
            int minute = this.utcCalendar.get(12);
            int second = this.utcCalendar.get(13);
            if ((hour | minute | second) == 0) {
                return new DateValueImpl(year, month, day);
            }
            return new DateTimeValueImpl(year, month, day, hour, minute, second);
        }
    }

    private static final class RecurrenceIterableWrapper
    implements DateIterable {
        private final RecurrenceIterable it;

        public RecurrenceIterableWrapper(RecurrenceIterable it) {
            this.it = it;
        }

        public DateIterator iterator() {
            return new RecurrenceIteratorWrapper(this.it.iterator());
        }
    }
}

