/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class Gobble {
    private final File file;
    private final InputStream in;
    private final Reader reader;

    public Gobble(File file) {
        this(file, null, null);
    }

    public Gobble(InputStream in) {
        this(null, in, null);
    }

    public Gobble(Reader reader) {
        this(null, null, reader);
    }

    private Gobble(File file, InputStream in, Reader reader) {
        this.file = file;
        this.in = in;
        this.reader = reader;
    }

    public String asString() throws IOException {
        return this.asString(Charset.defaultCharset().name());
    }

    public String asString(String charset) throws IOException {
        Reader reader = this.buildReader(charset);
        return this.consumeReader(reader);
    }

    public byte[] asByteArray() throws IOException {
        if (this.reader != null) {
            throw new IllegalStateException("Cannot get raw bytes from a Reader object.");
        }
        InputStream in = this.buildInputStream();
        return this.consumeInputStream(in);
    }

    private Reader buildReader(String charset) throws IOException {
        return this.reader == null ? new InputStreamReader(this.buildInputStream(), charset) : this.reader;
    }

    private InputStream buildInputStream() throws IOException {
        return this.in == null ? new BufferedInputStream(new FileInputStream(this.file)) : this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String consumeReader(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[4096];
        try {
            int read;
            while ((read = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, read);
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] consumeInputStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            int read;
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        finally {
            in.close();
        }
        return out.toByteArray();
    }
}

