/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import biweekly.Messages;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateTimeComponents
implements Comparable<DateTimeComponents>,
Serializable {
    private static final long serialVersionUID = 7668029303206402368L;
    private static final Pattern regex = Pattern.compile("^(\\d{4})-?(\\d{2})-?(\\d{2})(T(\\d{2}):?(\\d{2}):?(\\d{2})(Z?))?.*");
    private final int year;
    private final int month;
    private final int date;
    private final int hour;
    private final int minute;
    private final int second;
    private final boolean hasTime;
    private final boolean utc;

    public static DateTimeComponents parse(String dateString) {
        return DateTimeComponents.parse(dateString, null);
    }

    public static DateTimeComponents parse(String dateString, Boolean hasTime) {
        Matcher m = regex.matcher(dateString);
        if (!m.find()) {
            throw Messages.INSTANCE.getIllegalArgumentException(19, dateString);
        }
        int i = 1;
        int year = Integer.parseInt(m.group(i++));
        int month = Integer.parseInt(m.group(i++));
        int date = Integer.parseInt(m.group(i++));
        int n = ++i;
        ++i;
        String hourStr = m.group(n);
        if (hasTime == null) {
            hasTime = hourStr != null;
        }
        if (!hasTime.booleanValue()) {
            return new DateTimeComponents(year, month, date);
        }
        int hour = hourStr == null ? 0 : Integer.parseInt(hourStr);
        String minuteStr = m.group(i++);
        int minute = minuteStr == null ? 0 : Integer.parseInt(minuteStr);
        String secondStr = m.group(i++);
        int second = secondStr == null ? 0 : Integer.parseInt(secondStr);
        boolean utc = "Z".equals(m.group(i++));
        return new DateTimeComponents(year, month, date, hour, minute, second, utc);
    }

    public DateTimeComponents(DateTimeComponents original) {
        this(original, null, null, null, null, null, null, null);
    }

    public DateTimeComponents(DateTimeComponents original, Integer year, Integer month, Integer date, Integer hour, Integer minute, Integer second, Boolean utc) {
        this(year == null ? original.year : year, month == null ? original.month : month, date == null ? original.date : date, hour == null ? original.hour : hour, minute == null ? original.minute : minute, second == null ? original.second : second, utc == null ? original.utc : utc);
    }

    public DateTimeComponents(int year, int month, int date) {
        this(year, month, date, 0, 0, 0, false, false);
    }

    public DateTimeComponents(int year, int month, int date, int hour, int minute, int second, boolean utc) {
        this(year, month, date, hour, minute, second, utc, true);
    }

    private DateTimeComponents(int year, int month, int date, int hour, int minute, int second, boolean utc, boolean hasTime) {
        this.year = year;
        this.month = month;
        this.date = date;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.utc = utc;
        this.hasTime = hasTime;
    }

    public DateTimeComponents(Date date) {
        this(date, TimeZone.getDefault());
    }

    public DateTimeComponents(Date date, TimeZone timezone) {
        Calendar cal = Calendar.getInstance(timezone);
        cal.setTime(date);
        this.year = cal.get(1);
        this.month = cal.get(2) + 1;
        this.date = cal.get(5);
        this.hour = cal.get(11);
        this.minute = cal.get(12);
        this.second = cal.get(13);
        this.utc = false;
        this.hasTime = true;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDate() {
        return this.date;
    }

    public boolean hasTime() {
        return this.hasTime;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public boolean isUtc() {
        return this.utc;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeTime, boolean extended) {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setMinimumIntegerDigits(2);
        nf.setMaximumIntegerDigits(2);
        String dash = extended ? "-" : "";
        String colon = extended ? ":" : "";
        String z = this.utc ? "Z" : "";
        StringBuilder sb = new StringBuilder();
        sb.append(this.year).append(dash).append(nf.format(this.month)).append(dash).append(nf.format(this.date));
        if (includeTime) {
            sb.append("T").append(nf.format(this.hour)).append(colon).append(nf.format(this.minute)).append(colon).append(nf.format(this.second)).append(z);
        }
        return sb.toString();
    }

    public Date toDate() {
        TimeZone timezone = this.utc ? TimeZone.getTimeZone("UTC") : TimeZone.getDefault();
        return this.toDate(timezone);
    }

    public Date toDate(TimeZone timezone) {
        return this.toDate(Calendar.getInstance(timezone));
    }

    public Date toDate(Calendar c) {
        c.clear();
        c.set(1, this.year);
        c.set(2, this.month - 1);
        c.set(5, this.date);
        c.set(11, this.hour);
        c.set(12, this.minute);
        c.set(13, this.second);
        return c.getTime();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.date;
        result = 31 * result + (this.hasTime ? 1231 : 1237);
        result = 31 * result + this.hour;
        result = 31 * result + this.minute;
        result = 31 * result + this.month;
        result = 31 * result + this.second;
        result = 31 * result + (this.utc ? 1231 : 1237);
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimeComponents other = (DateTimeComponents)obj;
        if (this.date != other.date) {
            return false;
        }
        if (this.hasTime != other.hasTime) {
            return false;
        }
        if (this.hour != other.hour) {
            return false;
        }
        if (this.minute != other.minute) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        if (this.second != other.second) {
            return false;
        }
        if (this.utc != other.utc) {
            return false;
        }
        return this.year == other.year;
    }

    @Override
    public int compareTo(DateTimeComponents that) {
        int c = this.year - that.year;
        if (c != 0) {
            return c;
        }
        c = this.month - that.month;
        if (c != 0) {
            return c;
        }
        c = this.date - that.date;
        if (c != 0) {
            return c;
        }
        c = this.hour - that.hour;
        if (c != 0) {
            return c;
        }
        c = this.minute - that.minute;
        if (c != 0) {
            return c;
        }
        c = this.second - that.second;
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public boolean before(DateTimeComponents that) {
        return this.compareTo(that) < 0;
    }

    public boolean after(DateTimeComponents that) {
        return this.compareTo(that) > 0;
    }
}

