/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.property.EnumProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Status
extends EnumProperty {
    public static final String CANCELLED = "CANCELLED";
    public static final String DRAFT = "DRAFT";
    public static final String FINAL = "FINAL";
    public static final String IN_PROGRESS = "IN-PROGRESS";
    public static final String ACCEPTED = "ACCEPTED";
    public static final String DECLINED = "DECLINED";
    public static final String DELEGATED = "DELEGATED";
    public static final String SENT = "SENT";
    public static final String COMPLETED = "COMPLETED";
    public static final String CONFIRMED = "CONFIRMED";
    public static final String NEEDS_ACTION = "NEEDS-ACTION";
    public static final String TENTATIVE = "TENTATIVE";

    public Status(String status) {
        super(status);
    }

    public Status(Status original) {
        super(original);
    }

    public static Status tentative() {
        return Status.create(TENTATIVE);
    }

    public boolean isTentative() {
        return this.is(TENTATIVE);
    }

    public static Status confirmed() {
        return Status.create(CONFIRMED);
    }

    public boolean isConfirmed() {
        return this.is(CONFIRMED);
    }

    public static Status cancelled() {
        return Status.create(CANCELLED);
    }

    public boolean isCancelled() {
        return this.is(CANCELLED);
    }

    public static Status needsAction() {
        return Status.create(NEEDS_ACTION);
    }

    public boolean isNeedsAction() {
        return this.is(NEEDS_ACTION);
    }

    public static Status completed() {
        return Status.create(COMPLETED);
    }

    public boolean isCompleted() {
        return this.is(COMPLETED);
    }

    public static Status inProgress() {
        return Status.create(IN_PROGRESS);
    }

    public boolean isInProgress() {
        return this.is(IN_PROGRESS);
    }

    public static Status draft() {
        return Status.create(DRAFT);
    }

    public boolean isDraft() {
        return this.is(DRAFT);
    }

    public static Status final_() {
        return Status.create(FINAL);
    }

    public boolean isFinal() {
        return this.is(FINAL);
    }

    public static Status accepted() {
        return Status.create(ACCEPTED);
    }

    public boolean isAccepted() {
        return this.is(ACCEPTED);
    }

    public static Status declined() {
        return Status.create(DECLINED);
    }

    public boolean isDeclined() {
        return this.is(DECLINED);
    }

    public static Status delegated() {
        return Status.create(DELEGATED);
    }

    public boolean isDelegated() {
        return this.is(DELEGATED);
    }

    public static Status sent() {
        return Status.create(SENT);
    }

    public boolean isSent() {
        return this.is(SENT);
    }

    public static Status create(String status) {
        return new Status(status);
    }

    @Override
    protected Collection<String> getStandardValues(ICalVersion version) {
        switch (version) {
            case V1_0: {
                return Arrays.asList(ACCEPTED, COMPLETED, CONFIRMED, DECLINED, DELEGATED, NEEDS_ACTION, SENT, TENTATIVE);
            }
        }
        return Arrays.asList(CANCELLED, COMPLETED, CONFIRMED, DRAFT, FINAL, IN_PROGRESS, NEEDS_ACTION, TENTATIVE);
    }

    @Override
    protected Collection<ICalVersion> getValueSupportedVersions() {
        if (this.value == null) {
            return Collections.emptyList();
        }
        if (this.isCompleted() || this.isConfirmed() || this.isNeedsAction() || this.isTentative()) {
            return Arrays.asList(ICalVersion.values());
        }
        if (this.isCancelled() || this.isDraft() || this.isFinal() || this.isInProgress()) {
            return Arrays.asList(ICalVersion.V2_0_DEPRECATED, ICalVersion.V2_0);
        }
        if (this.isAccepted() || this.isDeclined() || this.isDelegated() || this.isSent()) {
            return Arrays.asList(ICalVersion.V1_0);
        }
        return Collections.emptyList();
    }

    @Override
    public Status copy() {
        return new Status(this);
    }
}

