/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.BinaryProperty;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attachment
extends BinaryProperty {
    private String contentId;

    public Attachment(String formatType, File file) throws IOException {
        super(file);
        this.setFormatType(formatType);
    }

    public Attachment(String formatType, byte[] data) {
        super(data);
        this.setFormatType(formatType);
    }

    public Attachment(String formatType, String uri) {
        super(uri);
        this.setFormatType(formatType);
    }

    public Attachment(Attachment original) {
        super(original);
        this.contentId = original.contentId;
    }

    @Override
    public void setData(byte[] data) {
        super.setData(data);
        this.contentId = null;
    }

    @Override
    public void setUri(String uri) {
        super.setUri(uri);
        this.contentId = null;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
        this.uri = null;
        this.data = null;
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        if (this.uri == null && this.data == null && this.contentId == null) {
            warnings.add(new ValidationWarning(26, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        Map<String, Object> values = super.toStringValues();
        values.put("contentId", this.contentId);
        return values;
    }

    @Override
    public Attachment copy() {
        return new Attachment(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.contentId == null ? 0 : this.contentId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        return !(this.contentId == null ? other.contentId != null : !this.contentId.equals(other.contentId));
    }
}

