/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.property.Trigger;
import biweekly.util.Duration;
import biweekly.util.ICalDate;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerScribe
extends ICalPropertyScribe<Trigger> {
    public TriggerScribe() {
        super(Trigger.class, "TRIGGER", ICalDataType.DURATION);
    }

    @Override
    protected ICalDataType _dataType(Trigger property, ICalVersion version) {
        return property.getDate() == null ? ICalDataType.DURATION : ICalDataType.DATE_TIME;
    }

    @Override
    protected String _writeText(Trigger property, WriteContext context) {
        Duration duration = property.getDuration();
        if (duration != null) {
            return duration.toString();
        }
        Date date = property.getDate();
        return TriggerScribe.date(date, (ICalProperty)property, context).extended(false).write();
    }

    @Override
    protected Trigger _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        value = VObjectPropertyValues.unescape((String)value);
        try {
            ICalDate date = TriggerScribe.date(value).parse();
            Trigger property = new Trigger(date);
            context.addDate(date, property, parameters);
            return property;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return new Trigger(Duration.parse(value), parameters.getRelated());
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw new CannotParseException(25, new Object[0]);
            }
        }
    }

    @Override
    protected void _writeXml(Trigger property, XCalElement element, WriteContext context) {
        Duration duration = property.getDuration();
        if (duration != null) {
            element.append(ICalDataType.DURATION, duration.toString());
            return;
        }
        Date date = property.getDate();
        if (date != null) {
            String dateStr = TriggerScribe.date(date, (ICalProperty)property, context).extended(true).write();
            element.append(ICalDataType.DATE_TIME, dateStr);
            return;
        }
        element.append(this.defaultDataType(context.getVersion()), "");
    }

    @Override
    protected Trigger _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        String value = element.first(ICalDataType.DURATION);
        if (value != null) {
            try {
                return new Trigger(Duration.parse(value), parameters.getRelated());
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(26, value);
            }
        }
        value = element.first(ICalDataType.DATE_TIME);
        if (value != null) {
            try {
                ICalDate date = TriggerScribe.date(value).parse();
                Trigger property = new Trigger(date);
                context.addDate(date, property, parameters);
                return property;
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(27, value);
            }
        }
        throw TriggerScribe.missingXmlElements(ICalDataType.DURATION, ICalDataType.DATE_TIME);
    }

    @Override
    protected JCalValue _writeJson(Trigger property, WriteContext context) {
        Duration duration = property.getDuration();
        if (duration != null) {
            return JCalValue.single(duration.toString());
        }
        Date date = property.getDate();
        if (date != null) {
            String dateStr = TriggerScribe.date(date, (ICalProperty)property, context).extended(true).write();
            return JCalValue.single(dateStr);
        }
        return JCalValue.single("");
    }

    @Override
    protected Trigger _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String valueStr = value.asSingle();
        try {
            ICalDate date = TriggerScribe.date(valueStr).parse();
            Trigger property = new Trigger(date);
            context.addDate(date, property, parameters);
            return property;
        }
        catch (IllegalArgumentException date) {
            try {
                return new Trigger(Duration.parse(valueStr), parameters.getRelated());
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(25, new Object[0]);
            }
        }
    }

    @Override
    public Set<ICalVersion> getSupportedVersions() {
        return EnumSet.of(ICalVersion.V2_0_DEPRECATED, ICalVersion.V2_0);
    }
}

