/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.json;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.io.CannotParseException;
import biweekly.io.ParseWarning;
import biweekly.io.SkipMeException;
import biweekly.io.StreamReader;
import biweekly.io.json.JCalRawReader;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.component.ICalendarScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.scribe.property.RawPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.property.RawProperty;
import biweekly.property.Version;
import biweekly.util.Utf8Reader;
import com.fasterxml.jackson.core.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JCalReader
extends StreamReader {
    private static final ICalendarScribe icalScribe = ScribeIndex.getICalendarScribe();
    private final JCalRawReader reader;

    public JCalReader(String json) {
        this(new StringReader(json));
    }

    public JCalReader(InputStream in) {
        this(new Utf8Reader(in));
    }

    public JCalReader(File file) throws FileNotFoundException {
        this(new BufferedReader(new Utf8Reader(file)));
    }

    public JCalReader(Reader reader) {
        this.reader = new JCalRawReader(reader);
    }

    public JCalReader(JsonParser parser) {
        this.reader = new JCalRawReader(parser, true);
    }

    public ICalendar _readNext() throws IOException {
        if (this.reader.eof()) {
            return null;
        }
        this.context.setVersion(ICalVersion.V2_0);
        JCalDataStreamListenerImpl listener = new JCalDataStreamListenerImpl();
        this.reader.readNext(listener);
        return listener.getICalendar();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JCalDataStreamListenerImpl
    implements JCalRawReader.JCalDataStreamListener {
        private final Map<List<String>, ICalComponent> components = new HashMap<List<String>, ICalComponent>();

        private JCalDataStreamListenerImpl() {
        }

        @Override
        public void readProperty(List<String> componentHierarchy, String propertyName, ICalParameters parameters, ICalDataType dataType, JCalValue value) {
            JCalReader.this.context.getWarnings().clear();
            JCalReader.this.context.setLineNumber(JCalReader.this.reader.getLineNum());
            JCalReader.this.context.setPropertyName(propertyName);
            ICalComponent parent = this.components.get(componentHierarchy);
            ICalPropertyScribe<? extends ICalProperty> scribe = JCalReader.this.index.getPropertyScribe(propertyName, ICalVersion.V2_0);
            try {
                Version version;
                ICalVersion icalVersion;
                ICalProperty property = scribe.parseJson(value, dataType, parameters, JCalReader.this.context);
                JCalReader.this.warnings.addAll(JCalReader.this.context.getWarnings());
                if (parent instanceof ICalendar && property instanceof Version && (icalVersion = (version = (Version)property).toICalVersion()) != null) {
                    JCalReader.this.context.setVersion(icalVersion);
                    return;
                }
                parent.addProperty(property);
            }
            catch (SkipMeException e) {
                JCalReader.this.warnings.add(new ParseWarning.Builder(JCalReader.this.context).message(0, e.getMessage()).build());
            }
            catch (CannotParseException e) {
                RawProperty property = (RawProperty)new RawPropertyScribe(propertyName).parseJson(value, dataType, parameters, JCalReader.this.context);
                parent.addProperty(property);
                JCalReader.this.warnings.add(new ParseWarning.Builder(JCalReader.this.context).message(e).build());
            }
        }

        @Override
        public void readComponent(List<String> parentHierarchy, String componentName) {
            ICalComponentScribe<? extends ICalComponent> scribe = JCalReader.this.index.getComponentScribe(componentName, ICalVersion.V2_0);
            ICalComponent component = scribe.emptyInstance();
            ICalComponent parent = this.components.get(parentHierarchy);
            if (parent != null) {
                parent.addComponent(component);
            }
            ArrayList<String> hierarchy = new ArrayList<String>(parentHierarchy);
            hierarchy.add(componentName);
            this.components.put(hierarchy, component);
        }

        public ICalendar getICalendar() {
            if (this.components.isEmpty()) {
                return null;
            }
            ICalComponent component = this.components.get(Arrays.asList(icalScribe.getComponentName().toLowerCase()));
            if (component == null) {
                return null;
            }
            if (component instanceof ICalendar) {
                return (ICalendar)component;
            }
            ICalendar ical = (ICalendar)icalScribe.emptyInstance();
            ical.addComponent(component);
            return ical;
        }
    }
}

