/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.chain;

import biweekly.ICalDataType;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.io.chain.ChainingWriter;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalDocument;
import biweekly.io.xml.XCalOutputProperties;
import biweekly.property.ICalProperty;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingXmlWriter
extends ChainingWriter<ChainingXmlWriter> {
    private final XCalOutputProperties outputProperties = new XCalOutputProperties();
    private final Map<String, ICalDataType> parameterDataTypes = new HashMap<String, ICalDataType>(0);

    public ChainingXmlWriter(Collection<ICalendar> icals) {
        super(icals);
    }

    public ChainingXmlWriter indent(Integer indent) {
        this.outputProperties.setIndent(indent);
        return this;
    }

    public ChainingXmlWriter xmlVersion(String xmlVersion) {
        this.outputProperties.setXmlVersion(xmlVersion);
        return this;
    }

    public ChainingXmlWriter outputProperty(String name, String value) {
        this.outputProperties.put(name, value);
        return this;
    }

    public ChainingXmlWriter outputProperties(Map<String, String> outputProperties) {
        this.outputProperties.putAll(outputProperties);
        return this;
    }

    @Override
    public ChainingXmlWriter tz(TimeZone defaultTimeZone, boolean outlookCompatible) {
        return (ChainingXmlWriter)super.tz(defaultTimeZone, outlookCompatible);
    }

    @Override
    public ChainingXmlWriter register(ICalPropertyScribe<? extends ICalProperty> scribe) {
        return (ChainingXmlWriter)super.register(scribe);
    }

    @Override
    public ChainingXmlWriter register(ICalComponentScribe<? extends ICalComponent> scribe) {
        return (ChainingXmlWriter)super.register(scribe);
    }

    public ChainingXmlWriter register(String parameterName, ICalDataType dataType) {
        this.parameterDataTypes.put(parameterName, dataType);
        return this;
    }

    public String go() {
        return this.createXCalDocument().write(this.outputProperties);
    }

    public void go(OutputStream out) throws TransformerException {
        this.createXCalDocument().write(out, (Map<String, String>)this.outputProperties);
    }

    public void go(File file) throws IOException, TransformerException {
        this.createXCalDocument().write(file, (Map<String, String>)this.outputProperties);
    }

    public void go(Writer writer) throws TransformerException {
        this.createXCalDocument().write(writer, (Map<String, String>)this.outputProperties);
    }

    public Document dom() {
        return this.createXCalDocument().getDocument();
    }

    private XCalDocument createXCalDocument() {
        XCalDocument document = new XCalDocument();
        XCalDocument.XCalDocumentStreamWriter writer = document.writer();
        if (this.defaultTimeZone != null) {
            writer.setGlobalTimezone(this.defaultTimeZone);
        }
        for (Map.Entry<String, ICalDataType> entry : this.parameterDataTypes.entrySet()) {
            String parameterName = entry.getKey();
            ICalDataType dataType = entry.getValue();
            writer.registerParameterDataType(parameterName, dataType);
        }
        if (this.index != null) {
            writer.setScribeIndex(this.index);
        }
        for (ICalendar ical : this.icals) {
            writer.write(ical);
        }
        return document;
    }
}

