/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.Messages;
import biweekly.component.VTimezone;
import biweekly.io.TzUrlDotOrgGenerator;
import biweekly.property.ValuedProperty;
import java.util.TimeZone;

public class TimezoneAssignment {
    private final TimeZone timezone;
    private final VTimezone component;
    private final String globalId;

    public TimezoneAssignment(TimeZone timezone, VTimezone component) {
        String id = ValuedProperty.getValue(component.getTimezoneId());
        if (id == null || id.trim().length() == 0) {
            throw Messages.INSTANCE.getIllegalArgumentException(14, new Object[0]);
        }
        this.timezone = timezone;
        this.component = component;
        this.globalId = null;
    }

    public TimezoneAssignment(TimeZone timezone, String globalId) {
        this.timezone = timezone;
        this.component = null;
        this.globalId = globalId;
    }

    public static TimezoneAssignment download(TimeZone timezone, boolean outlookCompatible) {
        TzUrlDotOrgGenerator generator = new TzUrlDotOrgGenerator(outlookCompatible);
        VTimezone component = generator.generate(timezone);
        return new TimezoneAssignment(timezone, component);
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public VTimezone getComponent() {
        return this.component;
    }

    public String getGlobalId() {
        return this.globalId;
    }
}

