/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.io.DataModelConverter;
import biweekly.io.ICalTimeZone;
import biweekly.io.ParseContext;
import biweekly.io.ParseWarning;
import biweekly.io.TimezoneAssignment;
import biweekly.io.TimezoneInfo;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.property.Daylight;
import biweekly.property.ICalProperty;
import biweekly.property.Timezone;
import biweekly.property.ValuedProperty;
import biweekly.util.ICalDate;
import biweekly.util.ICalDateFormat;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamReader
implements Closeable {
    protected final List<ParseWarning> warnings = new ArrayList<ParseWarning>();
    protected ScribeIndex index = new ScribeIndex();
    protected ParseContext context;

    public void registerScribe(ICalPropertyScribe<? extends ICalProperty> scribe) {
        this.index.register(scribe);
    }

    public void registerScribe(ICalComponentScribe<? extends ICalComponent> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public List<ParseWarning> getWarnings() {
        return new ArrayList<ParseWarning>(this.warnings);
    }

    public List<ICalendar> readAll() throws IOException {
        ICalendar ical;
        ArrayList<ICalendar> icals = new ArrayList<ICalendar>();
        while ((ical = this.readNext()) != null) {
            icals.add(ical);
        }
        return icals;
    }

    public ICalendar readNext() throws IOException {
        this.warnings.clear();
        this.context = new ParseContext();
        ICalendar ical = this._readNext();
        if (ical == null) {
            return null;
        }
        ical.setVersion(this.context.getVersion());
        this.handleTimezones(ical);
        return ical;
    }

    protected abstract ICalendar _readNext() throws IOException;

    private void handleTimezones(ICalendar ical) {
        TimezoneInfo tzinfo = ical.getTimezoneInfo();
        TimezoneAssignment vcalTimezone = this.extractVCalTimezone(ical);
        Iterator<VTimezone> it = ical.getComponents(VTimezone.class).iterator();
        while (it.hasNext()) {
            VTimezone component = it.next();
            String string = ValuedProperty.getValue(component.getTimezoneId());
            if (string == null || string.trim().length() == 0) {
                this.warnings.add(new ParseWarning.Builder().message(39, new Object[0]).build());
                continue;
            }
            ICalTimeZone timezone = new ICalTimeZone(component);
            tzinfo.getTimezones().add(new TimezoneAssignment((TimeZone)timezone, component));
            it.remove();
        }
        if (vcalTimezone != null) {
            for (ParseContext.TimezonedDate timezonedDate : this.context.getFloatingDates()) {
                ICalDate date = timezonedDate.getDate();
                Date realDate = date.getRawComponents().toDate(vcalTimezone.getTimeZone());
                date.setTime(realDate.getTime());
            }
        } else {
            for (ParseContext.TimezonedDate timezonedDate : this.context.getFloatingDates()) {
                tzinfo.setFloating(timezonedDate.getProperty(), true);
            }
        }
        for (Map.Entry entry : this.context.getTimezonedDates()) {
            TimezoneAssignment assignment;
            String tzid = (String)entry.getKey();
            boolean solidus = tzid.startsWith("/");
            if (solidus) {
                String globalId = tzid.substring(1);
                TimeZone timezone = ICalDateFormat.parseTimeZoneId(globalId);
                if (timezone == null) {
                    this.warnings.add(new ParseWarning.Builder().message(38, tzid).build());
                    continue;
                }
                assignment = new TimezoneAssignment(timezone, globalId);
                tzinfo.getTimezones().add(assignment);
            } else {
                assignment = tzinfo.getTimezoneById(tzid);
                if (assignment == null) {
                    TimeZone timezone = ICalDateFormat.parseTimeZoneId(tzid);
                    if (timezone == null) {
                        this.warnings.add(new ParseWarning.Builder().message(38, tzid).build());
                        continue;
                    }
                    assignment = new TimezoneAssignment(timezone, tzid);
                    tzinfo.getTimezones().add(assignment);
                    this.warnings.add(new ParseWarning.Builder().message(37, tzid).build());
                }
            }
            Calendar cal = Calendar.getInstance(assignment.getTimeZone());
            List timezonedDates = (List)entry.getValue();
            for (ParseContext.TimezonedDate timezonedDate : timezonedDates) {
                ICalProperty property = timezonedDate.getProperty();
                tzinfo.setTimezone(property, assignment);
                ICalDate date = timezonedDate.getDate();
                Date realDate = date.getRawComponents().toDate(cal);
                date.setTime(realDate.getTime());
                property.getParameters().setTimezoneId(null);
            }
        }
    }

    private TimezoneAssignment extractVCalTimezone(ICalendar ical) {
        List<Timezone> timezones;
        Timezone timezone;
        List<Daylight> daylights = ical.removeProperties(Daylight.class);
        VTimezone vcalComponent = DataModelConverter.convert(daylights, timezone = (timezones = ical.removeProperties(Timezone.class)).isEmpty() ? null : timezones.get(0));
        if (vcalComponent == null) {
            return null;
        }
        ICalTimeZone icalTimezone = new ICalTimeZone(vcalComponent);
        TimezoneInfo tzinfo = ical.getTimezoneInfo();
        TimezoneAssignment assignment = new TimezoneAssignment((TimeZone)icalTimezone, vcalComponent);
        tzinfo.setDefaultTimezone(assignment);
        return assignment;
    }
}

