/*
 * Decompiled with CFR 0.152.
 */
package biweekly;

import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.ICalProperty;
import biweekly.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationWarnings
implements Iterable<WarningsGroup> {
    private final List<WarningsGroup> warnings;

    public ValidationWarnings(List<WarningsGroup> warnings) {
        this.warnings = warnings;
    }

    public List<WarningsGroup> getByProperty(Class<? extends ICalProperty> propertyClass) {
        ArrayList<WarningsGroup> warnings = new ArrayList<WarningsGroup>();
        for (WarningsGroup group : this.warnings) {
            ICalProperty property = group.getProperty();
            if (property == null || propertyClass != property.getClass()) continue;
            warnings.add(group);
        }
        return warnings;
    }

    public List<WarningsGroup> getByComponent(Class<? extends ICalComponent> componentClass) {
        ArrayList<WarningsGroup> warnings = new ArrayList<WarningsGroup>();
        for (WarningsGroup group : this.warnings) {
            ICalComponent component = group.getComponent();
            if (component == null || componentClass != component.getClass()) continue;
            warnings.add(group);
        }
        return warnings;
    }

    public List<WarningsGroup> getWarnings() {
        return this.warnings;
    }

    public boolean isEmpty() {
        return this.warnings.isEmpty();
    }

    public String toString() {
        return StringUtils.join(this.warnings, StringUtils.NEWLINE);
    }

    @Override
    public Iterator<WarningsGroup> iterator() {
        return this.warnings.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WarningsGroup {
        private final ICalProperty property;
        private final ICalComponent component;
        private final List<ICalComponent> componentHierarchy;
        private final List<ValidationWarning> warnings;

        public WarningsGroup(ICalProperty property, List<ICalComponent> componentHierarchy, List<ValidationWarning> warning) {
            this(null, property, componentHierarchy, warning);
        }

        public WarningsGroup(ICalComponent component, List<ICalComponent> componentHierarchy, List<ValidationWarning> warning) {
            this(component, null, componentHierarchy, warning);
        }

        private WarningsGroup(ICalComponent component, ICalProperty property, List<ICalComponent> componentHierarchy, List<ValidationWarning> warning) {
            this.component = component;
            this.property = property;
            this.componentHierarchy = componentHierarchy;
            this.warnings = warning;
        }

        public ICalProperty getProperty() {
            return this.property;
        }

        public ICalComponent getComponent() {
            return this.component;
        }

        public List<ICalComponent> getComponentHierarchy() {
            return this.componentHierarchy;
        }

        public List<ValidationWarning> getWarnings() {
            return this.warnings;
        }

        public String toString() {
            final String prefix = "[" + this.buildPath() + "]: ";
            return StringUtils.join(this.warnings, StringUtils.NEWLINE, new StringUtils.JoinCallback<ValidationWarning>(){

                @Override
                public void handle(StringBuilder sb, ValidationWarning warning) {
                    sb.append(prefix).append(warning);
                }
            });
        }

        private String buildPath() {
            StringBuilder sb = new StringBuilder();
            if (!this.componentHierarchy.isEmpty()) {
                String delimitor = " > ";
                StringUtils.join(this.componentHierarchy, delimitor, sb, new StringUtils.JoinCallback<ICalComponent>(){

                    @Override
                    public void handle(StringBuilder sb, ICalComponent component) {
                        sb.append(component.getClass().getSimpleName());
                    }
                });
                sb.append(delimitor);
            }
            Object obj = this.property == null ? this.component : this.property;
            sb.append(obj.getClass().getSimpleName());
            return sb.toString();
        }
    }
}

