/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import java.util.Locale;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleHandlerException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountingTripleHandler
implements TripleHandler {
    private static final Logger logger = LoggerFactory.getLogger(CountingTripleHandler.class);
    private final boolean logTriples;
    private int count = 0;

    public CountingTripleHandler(boolean logTriples) {
        this.logTriples = logTriples;
    }

    public CountingTripleHandler() {
        this(false);
    }

    public int getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
    }

    public void startDocument(IRI documentIRI) throws TripleHandlerException {
    }

    public void openContext(ExtractionContext context) throws TripleHandlerException {
    }

    public void closeContext(ExtractionContext context) throws TripleHandlerException {
    }

    public void receiveTriple(Resource s, IRI p, Value o, IRI g, ExtractionContext context) throws TripleHandlerException {
        ++this.count;
        if (this.logTriples) {
            logger.debug(String.format(Locale.ROOT, "%s %s %s %s %s\n", s, p, o, g, context));
        }
    }

    public void receiveNamespace(String prefix, String uri, ExtractionContext context) throws TripleHandlerException {
    }

    public void close() throws TripleHandlerException {
    }

    public void endDocument(IRI documentIRI) throws TripleHandlerException {
    }

    public void setContentLength(long contentLength) {
    }
}

