/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.xerces.impl.io.MalformedByteSequenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class StreamUtils {
    private static final Logger logger = LoggerFactory.getLogger(StreamUtils.class);

    private StreamUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] asLines(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            String[] stringArray = lines.toArray(new String[lines.size()]);
            return stringArray;
        }
        finally {
            StreamUtils.closeGracefully(br);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String asString(InputStream is, boolean preserveNL) throws IOException {
        if (is == null) {
            throw new NullPointerException("input stream is null.");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        try {
            String line;
            StringBuilder content = new StringBuilder();
            while ((line = br.readLine()) != null) {
                content.append(line);
                if (!preserveNL) continue;
                content.append('\n');
            }
            String string = content.toString();
            return string;
        }
        finally {
            StreamUtils.closeGracefully(br);
        }
    }

    public static String asString(InputStream is) throws IOException {
        return StreamUtils.asString(is, false);
    }

    public static void closeGracefully(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (Exception e) {
                logger.error("Error while closing object " + closable, (Throwable)e);
            }
        }
    }

    public static InputStream documentToInputStream(Document doc) throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource xmlSource = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(outputStream);
        try {
            TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
        }
        catch (TransformerException e) {
            logger.error("Error during transformation: {}", (Throwable)e);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    public static Document inputStreamToDocument(InputStream is) throws MalformedByteSequenceException {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("Error converting InputStream to Document: {}", (Throwable)e);
        }
        try {
            BOMInputStream bomIn = new BOMInputStream(is, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE});
            if (bomIn.hasBOM()) {
                int n = bomIn.read();
            }
            doc = builder.parse((InputStream)bomIn);
        }
        catch (IOException | SAXException e) {
            logger.error("Error converting InputStream to Document: {}", (Throwable)e);
        }
        return doc;
    }
}

