/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.rdf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.any23.rdf.PopularPrefixes;
import org.apache.any23.util.MathUtils;
import org.apache.any23.util.StringUtils;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFUtils {
    private static int nodeId = 0;
    private static final ValueFactory valueFactory = SimpleValueFactory.getInstance();
    private static final Logger LOG = LoggerFactory.getLogger(RDFUtils.class);
    private static final Statement[] EMPTY_STATEMENTS = new Statement[0];

    private RDFUtils() {
    }

    public static String fixAbsoluteIRI(String uri) {
        String fixed = RDFUtils.fixIRIWithException(uri);
        if (!fixed.matches("[a-zA-Z0-9]+:/.*")) {
            throw new IllegalArgumentException("not a absolute org.eclipse.rdf4j.model.IRI: " + uri);
        }
        if (fixed.matches("https?://[a-zA-Z0-9.-]+(:[0-9+])?")) {
            fixed = fixed + "/";
        }
        return fixed;
    }

    public static String getXSDDate(String dateToBeParsed, String format) throws ParseException, DatatypeConfigurationException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.ROOT);
        Date date = simpleDateFormat.parse(dateToBeParsed);
        GregorianCalendar gc = new GregorianCalendar(TimeZone.getDefault(), Locale.ROOT);
        gc.setTime(date);
        XMLGregorianCalendar xml = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
        xml.setTimezone(0);
        return xml.toString();
    }

    public static String toXSDDateTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ROOT);
        String s = simpleDateFormat.format(date);
        StringBuilder sb = new StringBuilder(s);
        sb.insert(22, ':');
        return sb.toString();
    }

    public static String fixIRIWithException(String unescapedIRI) {
        if (unescapedIRI == null) {
            throw new IllegalArgumentException("org.eclipse.rdf4j.model.IRI was null");
        }
        String escapedIRI = unescapedIRI.trim();
        escapedIRI = escapedIRI.replaceAll(" ", "%20");
        if ((escapedIRI = escapedIRI.replaceAll("\n", "")).startsWith("\\") || escapedIRI.startsWith("\"")) {
            escapedIRI = escapedIRI.substring(1);
        }
        if (escapedIRI.endsWith("\\") || escapedIRI.endsWith("\"")) {
            escapedIRI = escapedIRI.substring(0, escapedIRI.length() - 1);
        }
        if (escapedIRI.matches("^[a-zA-Z0-9]+:/?/?$")) {
            throw new IllegalArgumentException("no authority in org.eclipse.rdf4j.model.IRI: " + unescapedIRI);
        }
        if (escapedIRI.matches("^javascript:")) {
            throw new IllegalArgumentException("org.eclipse.rdf4j.model.IRI starts with javascript: " + unescapedIRI);
        }
        if ((escapedIRI = escapedIRI.replaceAll(">.*$", "")).matches("[<>\\[\\]|\\*\\{\\}\"\\\\]")) {
            throw new IllegalArgumentException("Invalid character in org.eclipse.rdf4j.model.IRI: " + unescapedIRI);
        }
        return escapedIRI;
    }

    public static IRI iri(String iri) {
        return valueFactory.createIRI(iri);
    }

    public static IRI iri(String namespace, String localName) {
        return valueFactory.createIRI(namespace, localName);
    }

    public static Literal literal(String s) {
        return valueFactory.createLiteral(s);
    }

    public static Literal literal(boolean b) {
        return valueFactory.createLiteral(b);
    }

    public static Literal literal(byte b) {
        return valueFactory.createLiteral(b);
    }

    public static Literal literal(short s) {
        return valueFactory.createLiteral(s);
    }

    public static Literal literal(int i) {
        return valueFactory.createLiteral(i);
    }

    public static Literal literal(long l) {
        return valueFactory.createLiteral(l);
    }

    public static Literal literal(float f) {
        return valueFactory.createLiteral(f);
    }

    public static Literal literal(double d) {
        return valueFactory.createLiteral(d);
    }

    public static Literal literal(String s, String l) {
        if (l == null) {
            return valueFactory.createLiteral(s);
        }
        return valueFactory.createLiteral(s, l);
    }

    public static Literal literal(String s, IRI datatype) {
        return valueFactory.createLiteral(s, datatype);
    }

    public static BNode bnode(String id) {
        return valueFactory.createBNode(id);
    }

    public static BNode bnode() {
        return valueFactory.createBNode();
    }

    public static BNode getBNode(String id) {
        return valueFactory.createBNode("node" + MathUtils.md5(id));
    }

    public static Statement triple(Resource s, IRI p, Value o) {
        return valueFactory.createStatement(s, p, o);
    }

    public static Statement triple(String s, String p, String o) {
        return valueFactory.createStatement((Resource)RDFUtils.toValue(s), (IRI)RDFUtils.toValue(p), RDFUtils.toValue(o));
    }

    public static Statement quad(Resource s, IRI p, Value o, Resource g) {
        return valueFactory.createStatement(s, p, o, g);
    }

    public static Statement quad(String s, String p, String o, String g) {
        return valueFactory.createStatement((Resource)RDFUtils.toValue(s), (IRI)RDFUtils.toValue(p), RDFUtils.toValue(o), (Resource)RDFUtils.toValue(g));
    }

    public static Value toValue(String s) {
        if ("a".equals(s)) {
            return RDF.TYPE;
        }
        if (s.matches("[a-z0-9]+:.*")) {
            return PopularPrefixes.get().expand(s);
        }
        return valueFactory.createLiteral(s);
    }

    public static Collection<RDFFormat> getFormats() {
        return RDFParserRegistry.getInstance().getKeys();
    }

    public static RDFParser getParser(RDFFormat format) {
        return Rio.createParser((RDFFormat)format);
    }

    public static RDFWriter getWriter(RDFFormat format, Writer writer) {
        return Rio.createWriter((RDFFormat)format, (Writer)writer);
    }

    public static RDFWriter getWriter(RDFFormat format, OutputStream os) {
        return Rio.createWriter((RDFFormat)format, (OutputStream)os);
    }

    public static Optional<RDFFormat> getFormatByExtension(String ext) {
        if (!ext.startsWith(".")) {
            ext = "." + ext;
        }
        return Rio.getParserFormatForFileName((String)ext);
    }

    public static Statement[] parseRDF(RDFFormat format, InputStream is, String baseIRI) throws IOException {
        StatementCollector handler = new StatementCollector();
        RDFParser parser = RDFUtils.getParser(format);
        parser.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
        parser.setPreserveBNodeIDs(true);
        parser.setRDFHandler((RDFHandler)handler);
        parser.parse(is, baseIRI);
        return handler.getStatements().toArray(EMPTY_STATEMENTS);
    }

    public static Statement[] parseRDF(RDFFormat format, InputStream is) throws IOException {
        return RDFUtils.parseRDF(format, is, "");
    }

    public static Statement[] parseRDF(RDFFormat format, String in) throws IOException {
        return RDFUtils.parseRDF(format, new ByteArrayInputStream(in.getBytes(StandardCharsets.UTF_8)));
    }

    public static Statement[] parseRDF(String resource) throws IOException {
        int extIndex = resource.lastIndexOf(46);
        if (extIndex == -1) {
            throw new IllegalArgumentException("Error while detecting the extension in resource name " + resource);
        }
        String extension = resource.substring(extIndex + 1);
        return RDFUtils.parseRDF(RDFUtils.getFormatByExtension(extension).orElseThrow(Rio.unsupportedFormat((String)extension)), RDFUtils.class.getResourceAsStream(resource));
    }

    public static boolean isAbsoluteIRI(String href) {
        try {
            SimpleValueFactory.getInstance().createIRI(href.trim());
            new URI(href.trim());
            return true;
        }
        catch (IllegalArgumentException e) {
            LOG.trace("Error processing href: {}", (Object)href, (Object)e);
            return false;
        }
        catch (URISyntaxException e) {
            LOG.trace("Error interpreting href: {} as URI.", (Object)href, (Object)e);
            return false;
        }
    }

    public static Resource makeIRI(IRI docUri) {
        return RDFUtils.makeIRI("node", docUri);
    }

    public static Resource makeIRI(String type, IRI docIRI) {
        return RDFUtils.makeIRI(type, docIRI, false);
    }

    public static Resource makeIRI(String type, IRI docIRI, boolean addId) {
        String newType = StringUtils.implementJavaNaming(type);
        String iriString = docIRI.toString().endsWith("/") || docIRI.toString().endsWith("#") ? docIRI.toString() + newType : docIRI.toString() + "#" + newType;
        if (addId) {
            iriString = iriString + "_" + Integer.toString(nodeId);
        }
        IRI node = RDFUtils.iri(iriString);
        if (addId) {
            ++nodeId;
        }
        return node;
    }

    public static Value makeIRI(String inString) {
        if (RDFUtils.isAbsoluteIRI(inString)) {
            return RDFUtils.iri(inString);
        }
        return RDFUtils.literal(inString);
    }

    public static Value makeIRI() {
        BNode bnode = RDFUtils.bnode(Integer.toString(nodeId));
        ++nodeId;
        return bnode;
    }
}

