/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.rdf;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.rdf.BaseRDFExtractor;
import org.apache.any23.extractor.rdf.JSONLDExtractorFactory;
import org.apache.any23.extractor.rdf.JSONLDJavaSink;
import org.apache.any23.extractor.rdf.JsonCleaningInputStream;
import org.apache.any23.extractor.rdf.RDFParserFactory;
import org.apache.any23.rdf.Any23ValueFactoryWrapper;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFParser;

public class JSONLDExtractor
extends BaseRDFExtractor {
    private static final JsonFactory JSON_FACTORY = new JsonFactory((ObjectCodec)new ObjectMapper());

    @Deprecated
    public JSONLDExtractor(boolean verifyDataType, boolean stopAtFirstError) {
        super(verifyDataType, stopAtFirstError);
    }

    public JSONLDExtractor() {
        super(false, false);
    }

    public ExtractorDescription getDescription() {
        return JSONLDExtractorFactory.getDescriptionInstance();
    }

    @Override
    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, InputStream in, ExtractionResult extractionResult) throws IOException, ExtractionException {
        JSONLDJavaSink handler = new JSONLDJavaSink(extractionResult, new Any23ValueFactoryWrapper((ValueFactory)SimpleValueFactory.getInstance(), (IssueReport)extractionResult, extractionContext.getDefaultLanguage()));
        JsonLdOptions options = new JsonLdOptions(extractionContext.getDocumentIRI().stringValue());
        options.useNamespaces = true;
        try {
            Object json = JsonUtils.fromJsonParser((JsonParser)JSON_FACTORY.createParser((InputStream)new JsonCleaningInputStream(in)));
            JsonLdProcessor.toRDF((Object)json, (JsonLdTripleCallback)handler, (JsonLdOptions)options);
        }
        catch (JsonProcessingException e) {
            JsonLocation loc = e.getLocation();
            if (loc == null) {
                extractionResult.notifyIssue(IssueReport.IssueLevel.FATAL, e.getOriginalMessage(), -1L, -1L);
            } else {
                extractionResult.notifyIssue(IssueReport.IssueLevel.FATAL, e.getOriginalMessage(), (long)loc.getLineNr(), (long)loc.getColumnNr());
            }
        }
        catch (Exception e) {
            extractionResult.notifyIssue(IssueReport.IssueLevel.FATAL, JSONLDExtractor.toString(e), -1L, -1L);
        }
    }

    @Override
    @Deprecated
    public void setStopAtFirstError(boolean stopAtFirstError) {
        super.setStopAtFirstError(stopAtFirstError);
    }

    @Override
    @Deprecated
    public void setVerifyDataType(boolean verifyDataType) {
        super.setVerifyDataType(verifyDataType);
    }

    @Override
    @Deprecated
    protected RDFParser getParser(ExtractionContext extractionContext, ExtractionResult extractionResult) {
        return RDFParserFactory.getInstance().getJSONLDParser(this.isVerifyDataType(), this.isStopAtFirstError(), extractionContext, extractionResult);
    }

    static {
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
        JSON_FACTORY.disable(JsonParser.Feature.ALLOW_COMMENTS);
        JSON_FACTORY.disable(JsonParser.Feature.ALLOW_MISSING_VALUES);
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS);
        JSON_FACTORY.disable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
        JSON_FACTORY.disable(JsonParser.Feature.ALLOW_TRAILING_COMMA);
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES);
        JSON_FACTORY.disable(JsonParser.Feature.ALLOW_YAML_COMMENTS);
        JSON_FACTORY.enable(JsonParser.Feature.IGNORE_UNDEFINED);
        JSON_FACTORY.enable(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION);
        JSON_FACTORY.disable(JsonParser.Feature.STRICT_DUPLICATE_DETECTION);
    }
}

