/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.microdata;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.microdata.ItemProp;
import org.apache.any23.extractor.microdata.ItemPropValue;
import org.apache.any23.extractor.microdata.ItemScope;
import org.apache.any23.extractor.microdata.MicrodataParserException;
import org.apache.any23.extractor.microdata.MicrodataParserReport;
import org.apache.any23.rdf.RDFUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.jsoup.parser.Tag;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class MicrodataParser {
    private final Document document;
    private final Set<String> loopDetectorSet = new HashSet<String>();
    private final Map<Node, ItemScope> itemScopes = new HashMap<Node, ItemScope>();
    private final Map<Node, ItemPropValue> itemPropValues = new HashMap<Node, ItemPropValue>();
    private int dereferenceRecursionCounter = 0;
    private ErrorMode errorMode = ErrorMode.FULL_REPORT;
    private final List<MicrodataParserException> errors = new ArrayList<MicrodataParserException>();
    public static final String ITEMSCOPE_ATTRIBUTE = "itemscope";
    public static final String ITEMPROP_ATTRIBUTE = "itemprop";
    private static final String REVERSE_ITEMPROP_ATTRIBUTE = "itemprop-reverse";
    public static final Set<String> SRC_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("audio", "embed", "frame", "iframe", "img", "source", "track", "video", "input", "layer", "script", "textarea")));
    public static final Set<String> HREF_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("a", "area", "link")));
    private static final String[] EMPTY_STRINGS = new String[0];

    public MicrodataParser(Document document) {
        if (document == null) {
            throw new NullPointerException("Document cannot be null.");
        }
        this.document = document;
    }

    public static List<Node> getItemScopeNodes(Node node) {
        return DomUtils.findAllByAttributeName(node, ITEMSCOPE_ATTRIBUTE);
    }

    public static boolean isItemScope(Node node) {
        return DomUtils.readAttribute(node, ITEMSCOPE_ATTRIBUTE, null) != null;
    }

    public static List<Node> getItemPropNodes(Node node) {
        return DomUtils.findAllByAttributeName(node, ITEMPROP_ATTRIBUTE);
    }

    public static boolean isItemProp(Node node) {
        return DomUtils.readAttribute(node, ITEMPROP_ATTRIBUTE, null) != null;
    }

    private static boolean isContainedInItemScope(Node node) {
        for (Node p = node.getParentNode(); p != null; p = p.getParentNode()) {
            NamedNodeMap attrs = p.getAttributes();
            if (attrs == null || attrs.getNamedItem(ITEMSCOPE_ATTRIBUTE) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isContainedInId(Node node, Set<String> ids) {
        do {
            String id;
            if ((id = DomUtils.readAttribute(node, "id", null)) == null || !ids.contains(id)) continue;
            return true;
        } while ((node = node.getParentNode()) != null);
        return false;
    }

    public static List<Node> getTopLevelItemScopeNodes(Node node) {
        List<Node> itemScopes = MicrodataParser.getItemScopeNodes(node);
        ArrayList<Node> topLevelItemScopes = new ArrayList<Node>();
        ArrayList<Node> possibles = new ArrayList<Node>();
        for (Node itemScope : itemScopes) {
            if (!MicrodataParser.isItemProp(itemScope) && DomUtils.readAttribute(itemScope, REVERSE_ITEMPROP_ATTRIBUTE, null) == null) {
                topLevelItemScopes.add(itemScope);
                continue;
            }
            if (MicrodataParser.isContainedInItemScope(itemScope)) continue;
            possibles.add(itemScope);
        }
        if (!possibles.isEmpty()) {
            Set<String> refIds = itemScopes.stream().flatMap(n -> Arrays.stream(MicrodataParser.itemrefIds(n))).collect(Collectors.toSet());
            for (Node itemScope : possibles) {
                if (MicrodataParser.isContainedInId(itemScope, refIds)) continue;
                topLevelItemScopes.add(itemScope);
            }
        }
        return topLevelItemScopes;
    }

    public static MicrodataParserReport getMicrodata(Document document, ErrorMode errorMode) throws MicrodataParserException {
        List<Node> itemNodes = MicrodataParser.getTopLevelItemScopeNodes(document);
        ArrayList<ItemScope> items = new ArrayList<ItemScope>();
        MicrodataParser microdataParser = new MicrodataParser(document);
        microdataParser.setErrorMode(errorMode);
        for (Node itemNode : itemNodes) {
            items.add(microdataParser.getItemScope(itemNode));
        }
        return new MicrodataParserReport(items.toArray(new ItemScope[items.size()]), microdataParser.getErrors());
    }

    public static MicrodataParserReport getMicrodata(Document document) {
        try {
            return MicrodataParser.getMicrodata(document, ErrorMode.FULL_REPORT);
        }
        catch (MicrodataParserException mpe) {
            throw new IllegalStateException("Unexpected exception.", mpe);
        }
    }

    public static void getMicrodataAsJSON(Document document, PrintStream ps) {
        int i;
        MicrodataParserReport report = MicrodataParser.getMicrodata(document);
        ItemScope[] itemScopes = report.getDetectedItemScopes();
        MicrodataParserException[] errors = report.getErrors();
        ps.append("{ ");
        ps.append("\"result\" : [");
        for (i = 0; i < itemScopes.length; ++i) {
            if (i > 0) {
                ps.print(", ");
            }
            ps.print(itemScopes[i].toJSON());
        }
        ps.append("] ");
        if (errors != null && errors.length > 0) {
            ps.append(", ");
            ps.append("\"errors\" : [");
            for (i = 0; i < errors.length; ++i) {
                if (i > 0) {
                    ps.print(", ");
                }
                ps.print(errors[i].toJSON());
            }
            ps.append("] ");
        }
        ps.append("}");
    }

    public void setErrorMode(ErrorMode errorMode) {
        if (errorMode == null) {
            throw new IllegalArgumentException("errorMode must be not null.");
        }
        this.errorMode = errorMode;
    }

    public ErrorMode getErrorMode() {
        return this.errorMode;
    }

    public MicrodataParserException[] getErrors() {
        return this.errors == null ? new MicrodataParserException[]{} : this.errors.toArray(new MicrodataParserException[this.errors.size()]);
    }

    public ItemPropValue getPropertyValue(Node node) throws MicrodataParserException {
        ItemPropValue itemPropValue = this.itemPropValues.get(node);
        if (itemPropValue != null) {
            return itemPropValue;
        }
        if (MicrodataParser.isItemScope(node)) {
            return new ItemPropValue(this.getItemScope(node), ItemPropValue.Type.Nested);
        }
        String nodeName = node.getNodeName().toLowerCase(Locale.ROOT);
        if ("data".equals(nodeName) || "meter".equals(nodeName)) {
            String value = MicrodataParser.value(node, "value");
            Literal l = XMLDatatypeUtil.isValidInteger((String)value) ? RDFUtils.literal(value, XMLSchema.INTEGER) : (XMLDatatypeUtil.isValidDouble((String)value) ? RDFUtils.literal(value, XMLSchema.DOUBLE) : RDFUtils.literal(value));
            return new ItemPropValue(l);
        }
        if ("time".equals(nodeName)) {
            String dateTimeStr = MicrodataParser.value(node, "datetime");
            Literal l = XMLDatatypeUtil.isValidDate((String)dateTimeStr) ? RDFUtils.literal(dateTimeStr, XMLSchema.DATE) : (XMLDatatypeUtil.isValidTime((String)dateTimeStr) ? RDFUtils.literal(dateTimeStr, XMLSchema.TIME) : (XMLDatatypeUtil.isValidDateTime((String)dateTimeStr) ? RDFUtils.literal(dateTimeStr, XMLSchema.DATETIME) : (XMLDatatypeUtil.isValidGYearMonth((String)dateTimeStr) ? RDFUtils.literal(dateTimeStr, XMLSchema.GYEARMONTH) : (XMLDatatypeUtil.isValidGYear((String)dateTimeStr) ? RDFUtils.literal(dateTimeStr, XMLSchema.GYEAR) : (XMLDatatypeUtil.isValidDuration((String)dateTimeStr) ? RDFUtils.literal(dateTimeStr, XMLSchema.DURATION) : RDFUtils.literal(dateTimeStr, MicrodataParser.getLanguage(node)))))));
            return new ItemPropValue(l);
        }
        if (SRC_TAGS.contains(nodeName)) {
            return MicrodataParser.link(node, "src");
        }
        if (HREF_TAGS.contains(nodeName)) {
            return MicrodataParser.link(node, "href");
        }
        if ("object".equals(nodeName)) {
            return MicrodataParser.link(node, "data");
        }
        String val = DomUtils.readAttribute(node, "content", null);
        if (val != null) {
            return new ItemPropValue(RDFUtils.literal(val, MicrodataParser.getLanguage(node)));
        }
        Literal l = RDFUtils.literal(MicrodataParser.textContent(node), MicrodataParser.getLanguage(node));
        ItemPropValue newItemPropValue = new ItemPropValue(l);
        this.itemPropValues.put(node, newItemPropValue);
        return newItemPropValue;
    }

    private static String textContent(Node node) {
        StringBuilder content = new StringBuilder();
        MicrodataParser.appendFormatted(node, content, false);
        return content.toString();
    }

    private static boolean shouldSeparateWithNewline(CharSequence s0, CharSequence s1) {
        int i;
        int len = s1.length();
        for (i = 0; i < len; ++i) {
            char ch = s1.charAt(i);
            if (ch == '\n' || ch == '\r') {
                return false;
            }
            if (!Character.isWhitespace(ch)) break;
        }
        for (i = s0.length() - 1; i >= 0; --i) {
            char ch = s0.charAt(i);
            if (ch == '\n' || ch == '\r') {
                return false;
            }
            if (Character.isWhitespace(ch)) continue;
            return true;
        }
        return false;
    }

    private static boolean appendFormatted(Node node, StringBuilder sb, boolean needsNewline) {
        switch (node.getNodeType()) {
            case 3: {
                String text = node.getTextContent();
                if (text.isEmpty()) {
                    return needsNewline;
                }
                if (needsNewline && MicrodataParser.shouldSeparateWithNewline(sb, text)) {
                    sb.append('\n');
                }
                sb.append(text);
                return false;
            }
            case 1: {
                String nodeName = node.getNodeName().toLowerCase(Locale.ENGLISH);
                boolean thisNeedsNewline = "br".equals(nodeName) || Tag.valueOf((String)nodeName).isBlock();
                NodeList children = node.getChildNodes();
                boolean prevChildNeedsNewline = needsNewline || thisNeedsNewline;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    prevChildNeedsNewline = MicrodataParser.appendFormatted(children.item(i), sb, prevChildNeedsNewline);
                }
                return prevChildNeedsNewline || thisNeedsNewline;
            }
        }
        return needsNewline;
    }

    private static String content(Node node, String attrName) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            Node attr = attributes.getNamedItem("content");
            if (attr != null) {
                return attr.getNodeValue();
            }
            attr = attributes.getNamedItem(attrName);
            if (attr != null) {
                return attr.getNodeValue();
            }
        }
        return null;
    }

    private static String value(Node node, String attrName) {
        String content = MicrodataParser.content(node, attrName);
        return StringUtils.stripToEmpty((String)(content != null ? content : node.getTextContent()));
    }

    private static ItemPropValue link(Node node, String attrName) {
        String content = MicrodataParser.content(node, attrName);
        return content == null ? new ItemPropValue(RDFUtils.literal("")) : new ItemPropValue(content, ItemPropValue.Type.Link);
    }

    private static String getLanguage(Node node) {
        do {
            String lang;
            if (StringUtils.isNotBlank((CharSequence)(lang = DomUtils.readAttribute(node, "xml:lang", null)))) {
                return lang.trim();
            }
            lang = DomUtils.readAttribute(node, "lang", null);
            if (!StringUtils.isNotBlank((CharSequence)lang)) continue;
            return lang.trim();
        } while ((node = node.getParentNode()) != null);
        return null;
    }

    public List<ItemProp> getItemProps(final Node scopeNode, boolean skipRoot) throws MicrodataParserException {
        final LinkedHashSet<Node> accepted = new LinkedHashSet<Node>();
        boolean skipRootChildren = false;
        if (!skipRoot) {
            NamedNodeMap attributes = scopeNode.getAttributes();
            if (attributes.getNamedItem(ITEMPROP_ATTRIBUTE) != null || attributes.getNamedItem(REVERSE_ITEMPROP_ATTRIBUTE) != null) {
                accepted.add(scopeNode);
            }
            if (attributes.getNamedItem(ITEMSCOPE_ATTRIBUTE) != null) {
                skipRootChildren = true;
            }
        }
        if (!skipRootChildren) {
            TreeWalker treeWalker = ((DocumentTraversal)((Object)scopeNode.getOwnerDocument())).createTreeWalker(scopeNode, 1, new NodeFilter(){

                @Override
                public short acceptNode(Node node) {
                    if (node.getNodeType() == 1) {
                        NamedNodeMap attributes = node.getAttributes();
                        if ((attributes.getNamedItem(MicrodataParser.ITEMPROP_ATTRIBUTE) != null || attributes.getNamedItem(MicrodataParser.REVERSE_ITEMPROP_ATTRIBUTE) != null) && scopeNode != node) {
                            accepted.add(node);
                        }
                        if (attributes.getNamedItem(MicrodataParser.ITEMSCOPE_ATTRIBUTE) != null) {
                            return 2;
                        }
                    }
                    return 1;
                }
            }, false);
            while (treeWalker.nextNode() != null) {
            }
        }
        ArrayList<ItemProp> result = new ArrayList<ItemProp>();
        for (Node itemPropNode : accepted) {
            ItemPropValue itemPropValue;
            String itemProp = DomUtils.readAttribute(itemPropNode, ITEMPROP_ATTRIBUTE, null);
            String reverseProp = DomUtils.readAttribute(itemPropNode, REVERSE_ITEMPROP_ATTRIBUTE, null);
            boolean hasItemProp = StringUtils.isNotBlank((CharSequence)itemProp);
            boolean hasReverseProp = StringUtils.isNotBlank((CharSequence)reverseProp);
            if (!hasItemProp && !hasReverseProp) {
                this.manageError(new MicrodataParserException("invalid property name '" + itemProp + "'", itemPropNode));
                continue;
            }
            try {
                itemPropValue = this.getPropertyValue(itemPropNode);
            }
            catch (MicrodataParserException mpe) {
                this.manageError(mpe);
                continue;
            }
            if (hasItemProp) {
                for (String propertyName : itemProp.trim().split("\\s+")) {
                    result.add(new ItemProp(DomUtils.getXPathForNode(itemPropNode), propertyName, itemPropValue, false));
                }
            }
            if (!hasReverseProp) continue;
            if (itemPropValue.literal != null) {
                this.manageError(new MicrodataParserException("itemprop-reverse cannot point to a literal", itemPropNode));
                continue;
            }
            for (String propertyName : reverseProp.trim().split("\\s+")) {
                result.add(new ItemProp(DomUtils.getXPathForNode(itemPropNode), propertyName, itemPropValue, true));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemProp[] deferProperties(String ... refs) throws MicrodataParserException {
        ArrayList<ItemProp> result;
        block10: {
            Document document = this.document;
            ++this.dereferenceRecursionCounter;
            result = new ArrayList<ItemProp>();
            try {
                for (String ref : refs) {
                    if (this.loopDetectorSet.contains(ref)) {
                        throw new MicrodataParserException(String.format(Locale.ROOT, "Loop detected with depth %d while dereferencing itemProp '%s' .", this.dereferenceRecursionCounter - 1, ref), null);
                    }
                    this.loopDetectorSet.add(ref);
                    Element element = document.getElementById(ref);
                    if (element == null) {
                        this.manageError(new MicrodataParserException(String.format(Locale.ROOT, "Unknown itemProp id '%s'", ref), null));
                        continue;
                    }
                    result.addAll(this.getItemProps(element, false));
                }
            }
            catch (MicrodataParserException mpe) {
                if (this.dereferenceRecursionCounter == 1) {
                    this.manageError(mpe);
                    break block10;
                }
                throw mpe;
            }
            finally {
                --this.dereferenceRecursionCounter;
                if (this.dereferenceRecursionCounter == 0) {
                    this.loopDetectorSet.clear();
                }
            }
        }
        return result.toArray(new ItemProp[result.size()]);
    }

    private static String[] itemrefIds(Node node) {
        String itemref = DomUtils.readAttribute(node, "itemref", null);
        return StringUtils.isBlank((CharSequence)itemref) ? EMPTY_STRINGS : itemref.trim().split("\\s+");
    }

    public ItemScope getItemScope(Node node) throws MicrodataParserException {
        List<IRI> types;
        ItemProp[] deferredProperties;
        ItemScope itemScope = this.itemScopes.get(node);
        if (itemScope != null) {
            return itemScope;
        }
        String id = DomUtils.readAttribute(node, "id", null);
        String itemType = DomUtils.readAttribute(node, "itemtype", null);
        String itemId = DomUtils.readAttribute(node, "itemid", null);
        List<ItemProp> itemProps = this.getItemProps(node, true);
        String[] itemrefIDs = MicrodataParser.itemrefIds(node);
        try {
            deferredProperties = this.deferProperties(itemrefIDs);
        }
        catch (MicrodataParserException mpe) {
            mpe.setErrorNode(node);
            throw mpe;
        }
        for (ItemProp deferredProperty : deferredProperties) {
            if (itemProps.contains(deferredProperty)) {
                this.manageError(new MicrodataParserException(String.format(Locale.ROOT, "Duplicated deferred itemProp '%s'.", deferredProperty.getName()), node));
                continue;
            }
            itemProps.add(deferredProperty);
        }
        if (itemType == null) {
            types = Collections.emptyList();
        } else {
            types = new ArrayList();
            boolean canConcatWithPrev = false;
            for (String s : itemType.trim().split("\\s+")) {
                try {
                    canConcatWithPrev = types.addAll(ItemScope.stringToSingletonIRI(s));
                }
                catch (RuntimeException e) {
                    if (canConcatWithPrev) {
                        int lastInd = types.size() - 1;
                        try {
                            List<IRI> secondTry = ItemScope.stringToSingletonIRI(types.get(lastInd).stringValue() + " " + s);
                            types.remove(lastInd);
                            canConcatWithPrev = types.addAll(secondTry);
                        }
                        catch (RuntimeException e2) {
                            this.manageError(new MicrodataParserException(e.getMessage(), node));
                            canConcatWithPrev = false;
                        }
                        continue;
                    }
                    this.manageError(new MicrodataParserException(e.getMessage(), node));
                }
            }
        }
        ItemScope newItemScope = new ItemScope(DomUtils.getXPathForNode(node), itemProps.toArray(new ItemProp[itemProps.size()]), id, itemrefIDs, types, itemId);
        this.itemScopes.put(node, newItemScope);
        return newItemScope;
    }

    private void manageError(MicrodataParserException mpe) throws MicrodataParserException {
        switch (this.errorMode) {
            case FULL_REPORT: {
                this.errors.add(mpe);
                break;
            }
            case STOP_AT_FIRST_ERROR: {
                throw mpe;
            }
            default: {
                throw new IllegalStateException("Unsupported mode " + (Object)((Object)this.errorMode));
            }
        }
    }

    static enum ErrorMode {
        STOP_AT_FIRST_ERROR,
        FULL_REPORT;

    }
}

