/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.microdata;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.any23.extractor.microdata.Item;
import org.apache.any23.extractor.microdata.ItemProp;
import org.apache.any23.rdf.RDFUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.model.IRI;

public class ItemScope
extends Item {
    private final Map<String, List<ItemProp>> properties;
    private final String id;
    private final String[] refs;
    private final List<IRI> type;
    private final String itemId;
    private static final Pattern looksLikeStartsWithHost = Pattern.compile("[^:/.]+(\\.[^:/.]+)+(:\\d+)?([/#?].*)?");

    public ItemScope(String xpath, ItemProp[] itemProps, String id, String[] refs, String type, String itemId) {
        this(xpath, itemProps, id, refs, ItemScope.stringToSingletonIRI(type), itemId);
    }

    static List<IRI> stringToSingletonIRI(String type) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            ParsedIRI iri = ParsedIRI.create((String)type.trim());
            if (StringUtils.isBlank((CharSequence)iri.getScheme())) {
                String host = iri.getHost();
                if (StringUtils.isNotBlank((CharSequence)host)) {
                    iri = new ParsedIRI("http", iri.getUserInfo(), host, iri.getPort(), iri.getPath(), iri.getQuery(), iri.getFragment());
                } else {
                    String path = iri.getPath();
                    if (path != null && looksLikeStartsWithHost.matcher(path).matches()) {
                        iri = ParsedIRI.create((String)("http://" + iri.toString()));
                    }
                }
            }
            return Collections.singletonList(RDFUtils.iri(iri.toString()));
        }
        return Collections.emptyList();
    }

    ItemScope(String xpath, ItemProp[] itemProps, String id, String[] refs, List<IRI> types, String itemId) {
        super(xpath);
        if (itemProps == null) {
            throw new NullPointerException("itemProps list cannot be null.");
        }
        this.type = types;
        this.id = id;
        this.refs = refs;
        this.itemId = itemId;
        HashMap<String, ArrayList<ItemProp>> tmpProperties = new HashMap<String, ArrayList<ItemProp>>();
        for (ItemProp itemProp : itemProps) {
            String propName = itemProp.getName();
            ArrayList<ItemProp> propList = (ArrayList<ItemProp>)tmpProperties.get(propName);
            if (propList == null) {
                propList = new ArrayList<ItemProp>();
                tmpProperties.put(propName, propList);
            }
            propList.add(itemProp);
        }
        HashMap<String, List<ItemProp>> properties = new HashMap<String, List<ItemProp>>();
        for (Map.Entry propertiesEntry : tmpProperties.entrySet()) {
            properties.put((String)propertiesEntry.getKey(), (List<ItemProp>)propertiesEntry.getValue());
        }
        this.properties = properties;
    }

    public Map<String, List<ItemProp>> getProperties() {
        return this.properties;
    }

    public String getId() {
        return this.id;
    }

    public String[] getRefs() {
        return this.refs;
    }

    public URL getType() {
        try {
            return this.type.isEmpty() ? null : new URL(this.type.get(0).stringValue());
        }
        catch (MalformedURLException e) {
            try {
                return new URL(ParsedIRI.create((String)this.type.get(0).stringValue()).toASCIIString());
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    List<IRI> getTypes() {
        return this.type;
    }

    public String getItemId() {
        return this.itemId;
    }

    @Override
    public String toJSON() {
        StringBuilder sb = new StringBuilder();
        Collection<List<ItemProp>> itemPropsList = this.properties.values();
        int j = 0;
        for (List<ItemProp> itemProps : itemPropsList) {
            int i = 0;
            for (ItemProp itemProp : itemProps) {
                sb.append(itemProp);
                if (i < itemProps.size() - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            if (j < itemPropsList.size() - 1) {
                sb.append(", ");
            }
            ++j;
        }
        return String.format(Locale.ROOT, "{ \"xpath\" : \"%s\", \"id\" : %s, \"refs\" : %s, \"type\" : %s, \"itemid\" : %s, \"properties\" : [ %s ] }", this.getXpath(), this.id == null ? null : "\"" + this.id + "\"", this.refs == null ? null : this.toJSON(this.refs), this.type.isEmpty() ? null : "\"" + this.type.get(0) + "\"", this.itemId == null ? null : "\"" + this.itemId + "\"", sb.toString());
    }

    public String toString() {
        return this.toJSON();
    }

    @Override
    public int hashCode() {
        int i = this.properties == null ? 0 : this.properties.hashCode();
        i += this.id == null ? 0 : this.id.hashCode();
        i += this.refs == null ? 0 : Arrays.hashCode(this.refs);
        i += this.type == null ? 0 : this.type.hashCode();
        return i += this.itemId == null ? 0 : this.itemId.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ItemScope) {
            ItemScope other = (ItemScope)obj;
            return super.getXpath().equals(other.getXpath()) && (this.properties == null ? other.properties == null : this.properties.equals(other.properties)) && (this.id == null ? other.id == null : this.id.equals(other.id)) && (this.refs == null ? other.refs == null : Arrays.equals(this.refs, other.refs)) && (this.type == null ? other.type == null : this.type.equals(other.type)) && (this.itemId == null ? other.itemId == null : this.itemId.equals(other.itemId));
        }
        return false;
    }

    protected void acquireProperty(ItemProp itemProp) {
        List itemProps = this.properties.computeIfAbsent(itemProp.getName(), k -> new ArrayList());
        if (!itemProps.contains(itemProp)) {
            itemProps.add(itemProp);
        }
    }

    protected void disownProperty(ItemProp itemProp) {
        List<ItemProp> propList = this.properties.get(itemProp.getName());
        if (propList != null) {
            propList.remove(itemProp);
        }
    }

    private String toJSON(String[] in) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < in.length; ++i) {
            sb.append("\"");
            sb.append(in[i]);
            sb.append("\"");
            if (i >= in.length - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }
}

