/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.microdata;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.apache.any23.extractor.microdata.ItemScope;
import org.apache.any23.util.StringUtils;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class ItemPropValue {
    private final Object content;
    private final Type type;
    private static final ThreadLocal<SimpleDateFormat> sdf = new ThreadLocal();
    final Literal literal;

    public static Date parseDateTime(String dateStr) throws ParseException {
        return ItemPropValue.getSdf().parse(dateStr);
    }

    public static String formatDateTime(Date in) {
        return ItemPropValue.getSdf().format(in);
    }

    private static SimpleDateFormat getSdf() {
        SimpleDateFormat simpleDateFormat = sdf.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
            sdf.set(simpleDateFormat);
        }
        return simpleDateFormat;
    }

    public ItemPropValue(Object content, Type type) {
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.content = type.checkClass(content);
        this.literal = null;
    }

    ItemPropValue(Literal literal) {
        Type type;
        Object content;
        this.literal = literal;
        if (XMLSchema.DATE.equals((Object)literal.getDatatype()) || XMLSchema.DATETIME.equals((Object)literal.getDatatype())) {
            try {
                content = ItemPropValue.parseDateTime(literal.getLabel());
                type = Type.Date;
            }
            catch (Exception e) {
                content = literal.getLabel();
                type = Type.Plain;
            }
        } else {
            content = literal.getLabel();
            type = Type.Plain;
        }
        this.type = type;
        this.content = content;
    }

    public Object getContent() {
        return this.content;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isPlain() {
        return this.type == Type.Plain;
    }

    public boolean isLink() {
        return this.type == Type.Link;
    }

    public boolean isDate() {
        return this.type == Type.Date;
    }

    public boolean isNested() {
        return this.type == Type.Nested;
    }

    public boolean isInteger() {
        if (this.type != Type.Plain) {
            return false;
        }
        try {
            Integer.parseInt((String)this.content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isFloat() {
        if (this.type != Type.Plain) {
            return false;
        }
        try {
            Float.parseFloat((String)this.content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isNumber() {
        return this.isInteger() || this.isFloat();
    }

    public int getAsInteger() {
        return Integer.parseInt((String)this.content);
    }

    public float getAsFloat() {
        return Float.parseFloat((String)this.content);
    }

    public Date getAsDate() {
        return (Date)this.content;
    }

    public URL getAsLink() {
        try {
            return new URL((String)this.content);
        }
        catch (MalformedURLException murle) {
            throw new IllegalStateException("Error while parsing IRI.", murle);
        }
    }

    public ItemScope getAsNested() {
        return (ItemScope)this.content;
    }

    public String toJSON() {
        String contentStr = this.content instanceof String ? "\"" + StringUtils.escapeAsJSONString((String)this.content) + "\"" : (this.content instanceof Date ? "\"" + ItemPropValue.getSdf().format((Date)this.content) + "\"" : this.content.toString());
        return String.format(Locale.ROOT, "{ \"content\" : %s, \"type\" : \"%s\" }", new Object[]{contentStr, this.type});
    }

    public String toString() {
        return this.toJSON();
    }

    public int hashCode() {
        return this.content.hashCode() * this.type.hashCode() * 2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ItemPropValue) {
            ItemPropValue other = (ItemPropValue)obj;
            return this.content.equals(other.content) && this.type.equals((Object)other.type);
        }
        return false;
    }

    public static enum Type {
        Plain(String.class),
        Link(String.class),
        Date(Date.class),
        Nested(ItemScope.class);

        private final Class<?> contentClass;

        private Type(Class<?> contentClass) {
            this.contentClass = contentClass;
        }

        private Object checkClass(Object content) {
            Objects.requireNonNull(content, "content cannot be null");
            if (!this.contentClass.isInstance(content)) {
                throw new IllegalArgumentException("content must be a " + this.contentClass.getName() + " when type is " + (Object)((Object)this));
            }
            return content;
        }
    }
}

