/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html.microformats2;

import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.microformats2.HRecipeExtractorFactory;
import org.apache.any23.vocab.HRecipe;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HRecipeExtractor
extends EntityBasedMicroformatExtractor {
    private static final HRecipe vHRECIPE = HRecipe.getInstance();
    private static final String[] recipeFields = new String[]{"name", "ingredient", "yield", "instructions", "duration", "photo", "summary", "author", "published", "nutrition"};

    @Override
    public ExtractorDescription getDescription() {
        return HRecipeExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "h-recipe";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        BNode recipe = this.getBlankNodeFor(node);
        this.conditionallyAddResourceProperty((Resource)recipe, RDF.TYPE, HRecipeExtractor.vHRECIPE.Recipe);
        HTMLDocument fragment = new HTMLDocument(node);
        this.addName(fragment, recipe);
        this.addIngredients(fragment, recipe);
        this.addYield(fragment, recipe);
        this.addInstructions(fragment, recipe);
        this.addDurations(fragment, recipe);
        this.addPhoto(fragment, recipe);
        this.addSummary(fragment, recipe);
        this.addAuthors(fragment, recipe);
        this.addPublished(fragment, recipe);
        this.addNutritions(fragment, recipe);
        return true;
    }

    private void mapFieldWithProperty(HTMLDocument fragment, BNode recipe, String fieldClass, IRI property) {
        HTMLDocument.TextField title = fragment.getSingularTextField(fieldClass);
        this.conditionallyAddStringProperty(title.source(), (Resource)recipe, property, title.value());
    }

    private void addName(HTMLDocument fragment, BNode recipe) {
        this.mapFieldWithProperty(fragment, recipe, "p-" + recipeFields[0], HRecipeExtractor.vHRECIPE.fn);
    }

    private void addIngredients(HTMLDocument fragment, BNode recipe) {
        HTMLDocument.TextField[] ingredients;
        for (HTMLDocument.TextField ingredient : ingredients = fragment.getPluralTextField("p-" + recipeFields[1])) {
            this.conditionallyAddStringProperty(ingredient.source(), (Resource)recipe, HRecipeExtractor.vHRECIPE.ingredient, ingredient.value());
        }
    }

    private void addInstructions(HTMLDocument fragment, BNode recipe) {
        this.mapFieldWithProperty(fragment, recipe, "e-" + recipeFields[2], HRecipeExtractor.vHRECIPE.instructions);
    }

    private void addYield(HTMLDocument fragment, BNode recipe) {
        this.mapFieldWithProperty(fragment, recipe, "p-" + recipeFields[3], HRecipeExtractor.vHRECIPE.yield);
    }

    private void addDurations(HTMLDocument fragment, BNode recipe) {
        HTMLDocument.TextField[] durations;
        for (HTMLDocument.TextField duration : durations = fragment.getPluralTextField("dt-" + recipeFields[4])) {
            Node attribute = duration.source().getAttributes().getNamedItem("datetime");
            if (attribute == null) {
                this.conditionallyAddStringProperty(duration.source(), (Resource)recipe, HRecipeExtractor.vHRECIPE.duration, duration.value());
                continue;
            }
            this.conditionallyAddStringProperty(duration.source(), (Resource)recipe, HRecipeExtractor.vHRECIPE.duration, attribute.getNodeValue());
        }
    }

    private void addPhoto(HTMLDocument fragment, BNode recipe) throws ExtractionException {
        HTMLDocument.TextField[] photos;
        for (HTMLDocument.TextField photo : photos = fragment.getPluralUrlField("u-" + recipeFields[5])) {
            this.addIRIProperty((Resource)recipe, HRecipeExtractor.vHRECIPE.photo, fragment.resolveIRI(photo.value()));
        }
    }

    private void addSummary(HTMLDocument fragment, BNode recipe) {
        this.mapFieldWithProperty(fragment, recipe, "p-" + recipeFields[6], HRecipeExtractor.vHRECIPE.summary);
    }

    private void addAuthors(HTMLDocument fragment, BNode recipe) {
        HTMLDocument.TextField[] authors;
        for (HTMLDocument.TextField author : authors = fragment.getPluralTextField("p-" + recipeFields[7])) {
            this.conditionallyAddStringProperty(author.source(), (Resource)recipe, HRecipeExtractor.vHRECIPE.author, author.value());
        }
    }

    private void addPublished(HTMLDocument fragment, BNode recipe) {
        HTMLDocument.TextField[] durations;
        for (HTMLDocument.TextField duration : durations = fragment.getPluralTextField("dt-" + recipeFields[8])) {
            Node attribute = duration.source().getAttributes().getNamedItem("datetime");
            if (attribute == null) {
                this.conditionallyAddStringProperty(duration.source(), (Resource)recipe, HRecipeExtractor.vHRECIPE.published, duration.value());
                continue;
            }
            this.conditionallyAddStringProperty(duration.source(), (Resource)recipe, HRecipeExtractor.vHRECIPE.published, attribute.getNodeValue());
        }
    }

    private void addNutritions(HTMLDocument fragment, BNode recipe) {
        HTMLDocument.TextField[] nutritions;
        for (HTMLDocument.TextField nutrition : nutritions = fragment.getPluralTextField("p-" + recipeFields[9])) {
            this.conditionallyAddStringProperty(nutrition.source(), (Resource)recipe, HRecipeExtractor.vHRECIPE.nutrition, nutrition.value());
        }
    }
}

