/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html.microformats2;

import java.util.ArrayList;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.microformats2.HGeoExtractorFactory;
import org.apache.any23.vocab.VCard;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HGeoExtractor
extends EntityBasedMicroformatExtractor {
    private static final VCard vVCARD = VCard.getInstance();
    private static final String[] geoFields = new String[]{"latitude", "longitude", "altitude"};

    @Override
    public ExtractorDescription getDescription() {
        return HGeoExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "h-geo";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) {
        if (null == node) {
            return false;
        }
        HTMLDocument document = new HTMLDocument(node);
        BNode geo = this.getBlankNodeFor(node);
        out.writeTriple((Resource)geo, RDF.TYPE, (Value)HGeoExtractor.vVCARD.Location);
        String extractorName = this.getDescription().getExtractorName();
        ArrayList<HTMLDocument.TextField> geoNodes = new ArrayList<HTMLDocument.TextField>();
        for (String field : geoFields) {
            geoNodes.add(document.getSingularTextField("p-" + field));
        }
        if (((HTMLDocument.TextField)geoNodes.get(0)).source() == null) {
            String[] composed = document.getSingularUrlField("h-geo").value().split(";");
            for (int counter = 0; counter < composed.length; ++counter) {
                this.conditionallyAddStringProperty(document.getSingularUrlField("h-geo").source(), (Resource)geo, vVCARD.getProperty(geoFields[counter]), composed[counter]);
            }
        } else {
            for (int counter = 0; counter < geoNodes.size(); ++counter) {
                this.conditionallyAddStringProperty(((HTMLDocument.TextField)geoNodes.get(counter)).source(), (Resource)geo, vVCARD.getProperty(geoFields[counter]), ((HTMLDocument.TextField)geoNodes.get(counter)).value());
            }
        }
        TagSoupExtractionResult tser = (TagSoupExtractionResult)this.getCurrentExtractionResult();
        tser.addResourceRoot(document.getPathToLocalRoot(), (Resource)geo, this.getClass());
        return true;
    }
}

