/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.AdrExtractor;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HCardExtractorFactory;
import org.apache.any23.extractor.html.HCardName;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.annotations.Includes;
import org.apache.any23.vocab.VCard;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Includes(extractors={AdrExtractor.class})
public class HCardExtractor
extends EntityBasedMicroformatExtractor {
    private static final VCard vCARD = VCard.getInstance();
    private HCardName name = new HCardName();
    private HTMLDocument fragment;

    @Override
    public ExtractorDescription getDescription() {
        return HCardExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "vcard";
    }

    @Override
    protected void resetExtractor() {
        this.name.reset();
    }

    private void fixIncludes(HTMLDocument document, Node node, IssueReport report) {
        String id;
        Node header;
        NamedNodeMap attributes = node.getAttributes();
        if ("TD".equals(node.getNodeName()) && null != attributes.getNamedItem("headers") && null != (header = document.findNodeById(id = attributes.getNamedItem("headers").getNodeValue()))) {
            node.appendChild(header.cloneNode(true));
            attributes.removeNamedItem("headers");
        }
        for (Node current : DomUtils.findAllByAttributeName(document.getDocument(), "class")) {
            HTMLDocument.TextField refId;
            Node included;
            HTMLDocument.TextField id2;
            if (!DomUtils.hasClassName(current, "include")) continue;
            current.getAttributes().removeNamedItem("class");
            ArrayList<HTMLDocument.TextField> res = new ArrayList<HTMLDocument.TextField>();
            HTMLDocument.readUrlField(res, current);
            if (res.isEmpty() || null == (id2 = res.get(0)) || null == (included = document.findNodeById((refId = new HTMLDocument.TextField(StringUtils.substringAfter((String)id2.value(), (String)"#"), id2.source())).value()))) continue;
            if (DomUtils.isAncestorOf(included, current)) {
                int[] nodeLocation = DomUtils.getNodeLocation(current);
                report.notifyIssue(IssueReport.IssueLevel.WARNING, "Current node tries to include an ancestor node.", nodeLocation == null ? -1L : (long)nodeLocation[0], nodeLocation == null ? -1L : (long)nodeLocation[1]);
                continue;
            }
            current.appendChild(included.cloneNode(true));
        }
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        this.fragment = new HTMLDocument(node);
        this.fixIncludes(this.getHTMLDocument(), node, (IssueReport)out);
        BNode card = this.getBlankNodeFor(node);
        boolean foundSomething = false;
        this.readFn();
        this.readNames();
        this.readOrganization();
        foundSomething |= this.addFn((Resource)card);
        foundSomething |= this.addNames((Resource)card);
        foundSomething |= this.addOrganizationName((Resource)card);
        foundSomething |= this.addStringProperty("sort-string", (Resource)card, HCardExtractor.vCARD.sort_string);
        foundSomething |= this.addUrl((Resource)card);
        foundSomething |= this.addEmail((Resource)card);
        foundSomething |= this.addPhoto((Resource)card);
        foundSomething |= this.addLogo((Resource)card);
        foundSomething |= this.addUid((Resource)card);
        foundSomething |= this.addClass((Resource)card);
        foundSomething |= this.addStringProperty("bday", (Resource)card, HCardExtractor.vCARD.bday);
        foundSomething |= this.addStringProperty("rev", (Resource)card, HCardExtractor.vCARD.rev);
        foundSomething |= this.addStringProperty("tz", (Resource)card, HCardExtractor.vCARD.tz);
        foundSomething |= this.addCategory((Resource)card);
        foundSomething |= this.addStringProperty("card", (Resource)card, HCardExtractor.vCARD.class_);
        foundSomething |= this.addSubMicroformat("adr", (Resource)card, HCardExtractor.vCARD.adr);
        foundSomething |= this.addTelephones((Resource)card);
        foundSomething |= this.addStringProperty("title", (Resource)card, HCardExtractor.vCARD.title);
        foundSomething |= this.addStringProperty("role", (Resource)card, HCardExtractor.vCARD.role);
        foundSomething |= this.addStringMultiProperty("note", (Resource)card, HCardExtractor.vCARD.note);
        if (!(foundSomething |= this.addSubMicroformat("geo", (Resource)card, HCardExtractor.vCARD.geo))) {
            return false;
        }
        out.writeTriple((Resource)card, RDF.TYPE, (Value)HCardExtractor.vCARD.VCard);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)out;
        tser.addResourceRoot(DomUtils.getXPathListForNode(node), (Resource)card, this.getClass());
        return true;
    }

    private boolean addTelephones(Resource card) {
        boolean found = false;
        for (Node node : DomUtils.findAllByAttributeContains(this.fragment.getDocument(), "class", "tel")) {
            HTMLDocument telFragment = new HTMLDocument(node);
            HTMLDocument.TextField[] values = telFragment.getPluralUrlField("value");
            if (values.length == 0) {
                String[] typeAndValue = telFragment.getSingularUrlField("tel").value().split(":");
                if (typeAndValue.length > 1) {
                    found |= this.addTel(card, "tel", typeAndValue[1]);
                    continue;
                }
                found |= this.addTel(card, "tel", typeAndValue[0]);
                continue;
            }
            Object[] valuesStr = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                valuesStr[i] = values[i].value();
            }
            HTMLDocument.TextField[] types = telFragment.getPluralTextField("type");
            if (types.length == 0) {
                found |= this.addTel(card, "tel", StringUtils.join((Object[])valuesStr));
            }
            for (HTMLDocument.TextField type : types) {
                found |= this.addTel(card, type.value(), StringUtils.join((Object[])valuesStr));
            }
        }
        return found;
    }

    private boolean addTel(Resource card, String type, String value) {
        IRI tel = super.fixLink(value, "tel");
        IRI composed = vCARD.getProperty(type + "Tel", null);
        if (composed == null) {
            IRI simple = vCARD.getProperty(type, null);
            if (simple == null) {
                return this.conditionallyAddResourceProperty(card, HCardExtractor.vCARD.tel, tel);
            }
            return this.conditionallyAddResourceProperty(card, simple, tel);
        }
        return this.conditionallyAddResourceProperty(card, composed, tel);
    }

    private boolean addSubMicroformat(String className, Resource resource, IRI property) {
        List<Node> nodes = this.fragment.findAllByClassName(className);
        if (nodes.isEmpty()) {
            return false;
        }
        for (Node node : nodes) {
            this.addBNodeProperty(node, resource, property, this.getBlankNodeFor(node));
        }
        return true;
    }

    private boolean addStringProperty(String className, Resource resource, IRI property) {
        HTMLDocument.TextField textField = this.fragment.getSingularTextField(className);
        return this.conditionallyAddStringProperty(textField.source(), resource, property, textField.value());
    }

    private boolean addStringMultiProperty(String className, Resource resource, IRI property) {
        HTMLDocument.TextField[] fields = this.fragment.getPluralTextField(className);
        boolean found = false;
        for (HTMLDocument.TextField field : fields) {
            found |= this.conditionallyAddStringProperty(field.source(), resource, property, field.value());
        }
        return found;
    }

    private boolean addCategory(Resource card) {
        HTMLDocument.TextField[] categories = this.fragment.getPluralTextField("category");
        boolean found = false;
        for (HTMLDocument.TextField category : categories) {
            found |= this.conditionallyAddStringProperty(category.source(), card, HCardExtractor.vCARD.category, category.value());
        }
        return found;
    }

    private boolean addUid(Resource card) {
        HTMLDocument.TextField uid = this.fragment.getSingularUrlField("uid");
        return this.conditionallyAddStringProperty(this.fragment.getDocument(), card, HCardExtractor.vCARD.uid, uid.value());
    }

    private boolean addClass(Resource card) {
        HTMLDocument.TextField class_ = this.fragment.getSingularUrlField("class");
        return this.conditionallyAddStringProperty(this.fragment.getDocument(), card, HCardExtractor.vCARD.class_, class_.value());
    }

    private boolean addLogo(Resource card) throws ExtractionException {
        HTMLDocument.TextField[] links = this.fragment.getPluralUrlField("logo");
        boolean found = false;
        for (HTMLDocument.TextField link : links) {
            found |= this.conditionallyAddResourceProperty(card, HCardExtractor.vCARD.logo, this.getHTMLDocument().resolveIRI(link.value()));
        }
        return found;
    }

    private boolean addPhoto(Resource card) throws ExtractionException {
        HTMLDocument.TextField[] links = this.fragment.getPluralUrlField("photo");
        boolean found = false;
        for (HTMLDocument.TextField link : links) {
            found |= this.conditionallyAddResourceProperty(card, HCardExtractor.vCARD.photo, this.getHTMLDocument().resolveIRI(link.value()));
        }
        return found;
    }

    private boolean addEmail(Resource card) {
        String email = this.dropSubject(this.fragment.getSingularUrlField("email").value());
        return this.conditionallyAddResourceProperty(card, HCardExtractor.vCARD.email, this.fixLink(email, "mailto"));
    }

    private String dropSubject(String mail) {
        if (mail == null) {
            return null;
        }
        return mail.split("\\?")[0];
    }

    private void readNames() {
        for (String field : HCardName.FIELDS) {
            HTMLDocument.TextField[] values;
            for (HTMLDocument.TextField text : values = this.fragment.getPluralTextField(field)) {
                if ("".equals(text.value())) continue;
                this.name.setField(field, text);
            }
        }
    }

    private void addFieldTriple(Node n, BNode bn, String fieldName, String fieldValue) {
        this.conditionallyAddLiteralProperty(n, (Resource)bn, vCARD.getProperty(fieldName), this.valueFactory.createLiteral(fieldValue));
    }

    private boolean addNames(Resource card) {
        BNode n = this.valueFactory.createBNode();
        this.addBNodeProperty(this.fragment.getDocument(), card, HCardExtractor.vCARD.n, n);
        this.addIRIProperty((Resource)n, RDF.TYPE, HCardExtractor.vCARD.Name);
        for (String fieldName : HCardName.FIELDS) {
            if (!this.name.containsField(fieldName)) continue;
            if (this.name.isMultiField(fieldName)) {
                Collection<HTMLDocument.TextField> values = this.name.getFields(fieldName);
                for (HTMLDocument.TextField value : values) {
                    this.addFieldTriple(value.source(), n, fieldName, value.value());
                }
                continue;
            }
            HTMLDocument.TextField value = this.name.getField(fieldName);
            if (value == null) continue;
            this.addFieldTriple(value.source(), n, fieldName, value.value());
        }
        return true;
    }

    private void readFn() {
        this.name.setFullName(this.fragment.getSingularTextField("fn"));
    }

    private boolean addFn(Resource card) {
        HTMLDocument.TextField fullNameTextField = this.name.getFullName();
        if (fullNameTextField == null) {
            return false;
        }
        return this.conditionallyAddStringProperty(fullNameTextField.source(), card, HCardExtractor.vCARD.fn, fullNameTextField.value());
    }

    private void readOrganization() {
        Node node = this.fragment.findMicroformattedObjectNode("*", "org");
        if (node == null) {
            return;
        }
        HTMLDocument doc = new HTMLDocument(node);
        String nodeText = doc.getText();
        if (nodeText != null) {
            this.name.setOrganization(new HTMLDocument.TextField(nodeText, node));
        }
        if ((nodeText = doc.getSingularTextField("organization-name").value()) == null || "".equals(nodeText)) {
            nodeText = HTMLDocument.readTextField(node).value();
        }
        this.name.setOrganization(new HTMLDocument.TextField(nodeText, node));
        this.name.setOrganizationUnit(doc.getSingularTextField("organization-unit"));
    }

    private boolean addOrganizationName(Resource card) {
        if (this.name.getOrganization() == null) {
            return false;
        }
        BNode org = this.valueFactory.createBNode();
        this.addBNodeProperty(this.fragment.getDocument(), card, HCardExtractor.vCARD.org, org);
        this.addIRIProperty((Resource)org, RDF.TYPE, HCardExtractor.vCARD.Organization);
        HTMLDocument.TextField organizationTextField = this.name.getOrganization();
        this.conditionallyAddLiteralProperty(organizationTextField.source(), (Resource)org, HCardExtractor.vCARD.organization_name, this.valueFactory.createLiteral(organizationTextField.value()));
        HTMLDocument.TextField organizationUnitTextField = this.name.getOrganizationUnit();
        if (organizationUnitTextField != null) {
            this.conditionallyAddStringProperty(organizationUnitTextField.source(), (Resource)org, HCardExtractor.vCARD.organization_unit, organizationUnitTextField.value());
        }
        return true;
    }

    private boolean addUrl(Resource card) throws ExtractionException {
        HTMLDocument.TextField[] links = this.fragment.getPluralUrlField("url");
        boolean found = false;
        for (HTMLDocument.TextField link : links) {
            found |= this.conditionallyAddResourceProperty(card, HCardExtractor.vCARD.url, this.getHTMLDocument().resolveIRI(link.value()));
        }
        return found;
    }
}

