/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.EmbeddedJSONLDExtractorFactory;
import org.apache.any23.extractor.rdf.JSONLDExtractor;
import org.apache.any23.extractor.rdf.JSONLDExtractorFactory;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.vocab.SINDICE;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EmbeddedJSONLDExtractor
implements Extractor.TagSoupDOMExtractor {
    private static final SINDICE vSINDICE = SINDICE.getInstance();
    private IRI profile;
    private Map<String, IRI> prefixes = new HashMap<String, IRI>();
    private String documentLang;
    private JSONLDExtractor extractor;

    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, Document in, ExtractionResult out) throws IOException, ExtractionException {
        this.profile = this.extractProfile(in);
        this.documentLang = this.getDocumentLanguage(in);
        this.extractLinkDefinedPrefixes(in);
        String baseProfile = "http://vocab.sindice.net/any23#";
        if (this.profile != null) {
            baseProfile = this.profile.toString();
        }
        extractionContext.getDocumentIRI();
        Set<JSONLDScript> jsonldScripts = this.extractJSONLDScript(in, baseProfile, extractionParameters, extractionContext, out);
        for (JSONLDScript jSONLDScript : jsonldScripts) {
        }
    }

    private String getDocumentLanguage(Document in) {
        String lang = DomUtils.find(in, "string(/HTML/@lang)");
        if ("".equals(lang)) {
            return null;
        }
        return lang;
    }

    private IRI extractProfile(Document in) {
        String profile = DomUtils.find(in, "string(/HTML/@profile)");
        if ("".equals(profile)) {
            return null;
        }
        return SimpleValueFactory.getInstance().createIRI(profile);
    }

    private void extractLinkDefinedPrefixes(Document in) {
        List<Node> linkNodes = DomUtils.findAll(in, "/HTML/HEAD/LINK");
        for (Node linkNode : linkNodes) {
            String href;
            NamedNodeMap attributes = linkNode.getAttributes();
            Node relNode = attributes.getNamedItem("rel");
            String rel = relNode == null ? null : relNode.getTextContent();
            Node hrefNode = attributes.getNamedItem("href");
            String string = href = hrefNode == null ? null : hrefNode.getTextContent();
            if (rel == null || href == null || !RDFUtils.isAbsoluteIRI(href)) continue;
            this.prefixes.put(rel, SimpleValueFactory.getInstance().createIRI(href));
        }
    }

    private Set<JSONLDScript> extractJSONLDScript(Document in, String baseProfile, ExtractionParameters extractionParameters, ExtractionContext extractionContext, ExtractionResult out) throws IOException, ExtractionException {
        List<Node> scriptNodes = DomUtils.findAll(in, "//SCRIPT");
        HashSet<JSONLDScript> result = new HashSet<JSONLDScript>();
        this.extractor = new JSONLDExtractorFactory().createExtractor();
        for (Node jsonldNode : scriptNodes) {
            NamedNodeMap attributes = jsonldNode.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!"application/ld+json".equalsIgnoreCase(attributes.item(i).getTextContent())) continue;
                this.extractor.run(extractionParameters, extractionContext, IOUtils.toInputStream((String)jsonldNode.getTextContent(), (Charset)StandardCharsets.UTF_8), out);
            }
            Node nameAttribute = attributes.getNamedItem("name");
            Node contentAttribute = attributes.getNamedItem("content");
            if (nameAttribute == null || contentAttribute == null) continue;
            String name = nameAttribute.getTextContent();
            String content = contentAttribute.getTextContent();
            String xpath = DomUtils.getXPathForNode(jsonldNode);
            IRI nameAsIRI = this.getPrefixIfExists(name);
            if (nameAsIRI == null) {
                nameAsIRI = SimpleValueFactory.getInstance().createIRI(baseProfile + name);
            }
            JSONLDScript jsonldScript = new JSONLDScript(xpath, nameAsIRI, content);
            result.add(jsonldScript);
        }
        return result;
    }

    private IRI getPrefixIfExists(String name) {
        String[] split = name.split("\\.");
        if (split.length == 2 && this.prefixes.containsKey(split[0])) {
            return SimpleValueFactory.getInstance().createIRI(this.prefixes.get(split[0]) + split[1]);
        }
        return null;
    }

    public ExtractorDescription getDescription() {
        return EmbeddedJSONLDExtractorFactory.getDescriptionInstance();
    }

    private class JSONLDScript {
        private String xpath;

        public JSONLDScript(String xpath, IRI name, String content) {
            this.xpath = xpath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof JSONLDScript)) {
                return false;
            }
            JSONLDScript meta = (JSONLDScript)o;
            return !(this.xpath != null ? !this.xpath.equals(meta.xpath) : meta.xpath != null);
        }

        public int hashCode() {
            return this.xpath != null ? this.xpath.hashCode() : 0;
        }
    }
}

