/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.vocab;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.util.DiscoveryUtils;
import org.apache.any23.util.StringUtils;
import org.apache.any23.vocab.Vocabulary;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;

public class RDFSchemaUtils {
    private static final String RDF_XML_SEPARATOR = StringUtils.multiply('=', 100);

    private RDFSchemaUtils() {
    }

    public static void serializeVocabulary(IRI namespace, IRI[] classes, IRI[] properties, Map<IRI, String> comments, RDFWriter writer) {
        String comment;
        writer.startRDF();
        for (IRI clazz : classes) {
            writer.handleStatement(RDFUtils.quad((Resource)clazz, RDF.TYPE, (Value)RDFS.CLASS, (Resource)namespace));
            writer.handleStatement(RDFUtils.quad((Resource)clazz, RDFS.MEMBER, (Value)namespace, (Resource)namespace));
            comment = comments.get(clazz);
            if (comment == null) continue;
            writer.handleStatement(RDFUtils.quad((Resource)clazz, RDFS.COMMENT, (Value)RDFUtils.literal(comment), (Resource)namespace));
        }
        for (IRI property : properties) {
            writer.handleStatement(RDFUtils.quad((Resource)property, RDF.TYPE, (Value)RDF.PROPERTY, (Resource)namespace));
            writer.handleStatement(RDFUtils.quad((Resource)property, RDFS.MEMBER, (Value)namespace, (Resource)namespace));
            comment = comments.get(property);
            if (comment == null) continue;
            writer.handleStatement(RDFUtils.quad((Resource)property, RDFS.COMMENT, (Value)RDFUtils.literal(comment), (Resource)namespace));
        }
        writer.endRDF();
    }

    public static void serializeVocabulary(Vocabulary vocabulary, RDFWriter writer) {
        RDFSchemaUtils.serializeVocabulary(vocabulary.getNamespace(), vocabulary.getClasses(), vocabulary.getProperties(), vocabulary.getComments(), writer);
    }

    public static void serializeVocabulary(Vocabulary vocabulary, RDFFormat format, boolean willFollowAnother, PrintStream ps) {
        RDFWriter rdfWriter;
        if (format == RDFFormat.RDFXML) {
            rdfWriter = Rio.createWriter((RDFFormat)RDFFormat.RDFXML, (OutputStream)ps);
            if (willFollowAnother) {
                ps.print("\n");
            }
            ps.print(RDF_XML_SEPARATOR);
            ps.print("\n");
        } else {
            rdfWriter = Rio.createWriter((RDFFormat)format, (OutputStream)ps);
        }
        RDFSchemaUtils.serializeVocabulary(vocabulary, rdfWriter);
    }

    public static String serializeVocabulary(Vocabulary vocabulary, RDFFormat format) {
        PrintStream ps;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ps = new PrintStream((OutputStream)baos, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException("UTF-8 encoding error when serializing the vocabulary to NQuads.", e1);
        }
        RDFSchemaUtils.serializeVocabulary(vocabulary, format, false, ps);
        ps.close();
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error writing ByteArrayOutputStream to String with \"UTF-8\" encoding!");
        }
    }

    public static void serializeVocabularies(RDFFormat format, PrintStream ps) {
        Class<Vocabulary> vocabularyClass = Vocabulary.class;
        List<Class> vocabularies = DiscoveryUtils.getClassesInPackage(vocabularyClass.getPackage().getName(), vocabularyClass);
        int currentIndex = 0;
        for (Class vocabClazz : vocabularies) {
            Vocabulary instance;
            try {
                Constructor constructor = vocabClazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                instance = (Vocabulary)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while instantiating vocabulary class " + vocabClazz, e);
            }
            try {
                RDFSchemaUtils.serializeVocabulary(instance, format, currentIndex < vocabularies.size() - 2, ps);
            }
            catch (RDFHandlerException rdfhe) {
                throw new RuntimeException("Error while serializing vocabulary.", rdfhe);
            }
        }
    }
}

