/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.util;

import java.util.Locale;

public class StringUtils {
    public static String join(String delimiter, String ... data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            sb.append(data[i]);
            if (i >= data.length - 1) break;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static int countOccurrences(String container, String content) {
        int lastIndex;
        int currIndex = 0;
        int occurrences = 0;
        while ((lastIndex = container.indexOf(content, currIndex)) != -1) {
            currIndex = lastIndex + content.length();
            ++occurrences;
        }
        return occurrences;
    }

    public static int countNL(String in) {
        return StringUtils.countOccurrences(in, "\n");
    }

    public static boolean isPrefix(String candidatePrefix, String container) {
        if (candidatePrefix == null || container == null) {
            throw new NullPointerException("Arguments must be not null.");
        }
        if (candidatePrefix.length() > container.length()) {
            return false;
        }
        for (int i = 0; i < candidatePrefix.length(); ++i) {
            if (candidatePrefix.charAt(i) == container.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuffix(String candidateSuffix, String container) {
        if (candidateSuffix == null || container == null) {
            throw new NullPointerException("Arguments must be not null.");
        }
        if (candidateSuffix.length() > container.length()) {
            return false;
        }
        int lenDiff = container.length() - candidateSuffix.length();
        for (int i = candidateSuffix.length() - 1; i >= 0; --i) {
            if (candidateSuffix.charAt(i) == container.charAt(i + lenDiff)) continue;
            return false;
        }
        return true;
    }

    public static String escapeDoubleQuotes(String in) {
        StringBuilder out = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (current == '\\') {
                escaped = !escaped;
            } else if (current == '\"' && !escaped) {
                out.append('\\');
            }
            out.append(current);
        }
        return out.toString();
    }

    public static String escapeAsJSONString(String in) {
        return StringUtils.escapeDoubleQuotes(in.replaceAll("\n", "\\\\n"));
    }

    public static String multiply(char c, int times) {
        if (times <= 0) {
            throw new IllegalArgumentException("Invalid number of times, must be > 0 .");
        }
        char[] buffer = new char[times];
        for (int i = 0; i < times; ++i) {
            buffer[i] = c;
        }
        return new String(buffer);
    }

    public static String implementJavaNaming(String in) {
        if ((in = in.trim().replaceAll("-", "_")).matches("\\S+")) {
            return org.apache.commons.lang3.StringUtils.uncapitalize((String)in);
        }
        in = in.toLowerCase(Locale.ROOT);
        String[] words = in.split("\\s+");
        StringBuilder sb = new StringBuilder(in.length());
        sb.append(words[0]);
        for (int i = 1; i < words.length; ++i) {
            sb.append(org.apache.commons.lang3.StringUtils.capitalize((String)words[i]));
        }
        return sb.toString();
    }

    private StringUtils() {
    }
}

