/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.rdf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.any23.rdf.Prefixes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopularPrefixes {
    private static final Logger logger = LoggerFactory.getLogger(PopularPrefixes.class);
    private static final String RESOURCE_NAME = "/org/apache/any23/prefixes/prefixes.properties";
    private static final Prefixes popularPrefixes = PopularPrefixes.getPrefixes();

    private static Prefixes getPrefixes() {
        Prefixes prefixes = new Prefixes();
        Properties properties = new Properties();
        try {
            logger.trace(String.format(Locale.ROOT, "Loading prefixes from %s", RESOURCE_NAME));
            properties.load(PopularPrefixes.getResourceAsStream());
        }
        catch (IOException e) {
            logger.error(String.format(Locale.ROOT, "Error while loading prefixes from %s", RESOURCE_NAME), (Throwable)e);
            throw new RuntimeException(String.format(Locale.ROOT, "Error while loading prefixes from %s", RESOURCE_NAME));
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (PopularPrefixes.testIRICompliance((String)entry.getValue())) {
                prefixes.add((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            logger.warn(String.format(Locale.ROOT, "Prefixes entry '%s' is not a well-formad IRI. Skipped.", entry.getValue()));
        }
        return prefixes;
    }

    public static Prefixes createSubset(String ... prefixes) {
        return popularPrefixes.createSubset(prefixes);
    }

    public static Prefixes get() {
        return popularPrefixes;
    }

    private static boolean testIRICompliance(String stringUri) {
        try {
            new URI(stringUri);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    private static InputStream getResourceAsStream() {
        InputStream result = PopularPrefixes.class.getResourceAsStream(RESOURCE_NAME);
        if (result == null && (result = PopularPrefixes.class.getClassLoader().getResourceAsStream(RESOURCE_NAME)) == null) {
            result = ClassLoader.getSystemResourceAsStream(RESOURCE_NAME);
        }
        return result;
    }
}

