/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.microdata;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.microdata.ItemProp;
import org.apache.any23.extractor.microdata.ItemPropValue;
import org.apache.any23.extractor.microdata.ItemScope;
import org.apache.any23.extractor.microdata.MicrodataExtractorFactory;
import org.apache.any23.extractor.microdata.MicrodataParser;
import org.apache.any23.extractor.microdata.MicrodataParserException;
import org.apache.any23.extractor.microdata.MicrodataParserReport;
import org.apache.any23.rdf.RDFUtils;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Document;

public class MicrodataExtractor
implements Extractor.TagSoupDOMExtractor {
    static final IRI MICRODATA_ITEM = RDFUtils.iri("http://www.w3.org/1999/xhtml/microdata#item");
    private static final ParsedIRI EMPTY_FRAG = ParsedIRI.create((String)"#");
    private static final String hcardPrefix = "http://microformats.org/profile/hcard";
    private static final IRI hcardNamespaceIRI = RDFUtils.iri("http://microformats.org/profile/hcard#");

    public ExtractorDescription getDescription() {
        return MicrodataExtractorFactory.getDescriptionInstance();
    }

    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, Document in, ExtractionResult out) throws IOException, ExtractionException {
        IRI defaultNamespace;
        ItemScope[] itemScopes;
        MicrodataParserReport parserReport = MicrodataParser.getMicrodata(in);
        if (parserReport.getErrors().length > 0) {
            this.notifyError(parserReport.getErrors(), out);
        }
        if ((itemScopes = parserReport.getDetectedItemScopes()).length == 0) {
            return;
        }
        IRI documentIRI = extractionContext.getDocumentIRI();
        ParsedIRI parsedDocumentIRI = ParsedIRI.create((String)documentIRI.stringValue());
        boolean isStrict = extractionParameters.getFlag("any23.microdata.strict");
        if (!isStrict) {
            defaultNamespace = RDFUtils.iri(extractionParameters.getProperty("any23.microdata.ns.default"));
            if (!defaultNamespace.getLocalName().isEmpty()) {
                throw new IllegalArgumentException("invalid namespace IRI: " + defaultNamespace);
            }
        } else {
            defaultNamespace = RDFUtils.iri(parsedDocumentIRI.resolve(EMPTY_FRAG).toString());
        }
        HashMap<ItemScope, Resource> mappings = new HashMap<ItemScope, Resource>();
        for (ItemScope itemScope : itemScopes) {
            Resource subject = this.processType(itemScope, parsedDocumentIRI, out, mappings, defaultNamespace);
            out.writeTriple((Resource)documentIRI, MICRODATA_ITEM, (Value)subject);
        }
    }

    private Resource processType(ItemScope itemScope, ParsedIRI documentIRI, ExtractionResult out, Map<ItemScope, Resource> mappings, IRI defaultNamespace) throws ExtractionException {
        Resource subject = mappings.computeIfAbsent(itemScope, scope -> MicrodataExtractor.createSubjectForItemId(documentIRI, scope.getItemId()));
        List<IRI> itemScopeTypes = itemScope.getTypes();
        if (!itemScopeTypes.isEmpty()) {
            defaultNamespace = MicrodataExtractor.getNamespaceIRI(itemScopeTypes.get(0));
            for (IRI type : itemScopeTypes) {
                out.writeTriple(subject, RDF.TYPE, (Value)type);
            }
        }
        for (Map.Entry<String, List<ItemProp>> itemProps : itemScope.getProperties().entrySet()) {
            String propName = itemProps.getKey();
            IRI predicate = MicrodataExtractor.getPredicate(defaultNamespace, propName);
            if (predicate == null) continue;
            for (ItemProp itemProp : itemProps.getValue()) {
                try {
                    this.processProperty(subject, predicate, itemProp, documentIRI, mappings, out, defaultNamespace);
                }
                catch (URISyntaxException e) {
                    throw new ExtractionException("Error while processing on subject '" + subject + "' the itemProp: '" + itemProp + "' ");
                }
            }
        }
        return subject;
    }

    private static Resource createSubjectForItemId(ParsedIRI documentIRI, String itemId) {
        if (itemId == null) {
            return RDFUtils.bnode();
        }
        try {
            return MicrodataExtractor.toAbsoluteIRI(documentIRI, itemId);
        }
        catch (URISyntaxException e) {
            return RDFUtils.bnode();
        }
    }

    private void processProperty(Resource subject, IRI predicate, ItemProp itemProp, ParsedIRI documentIRI, Map<ItemScope, Resource> mappings, ExtractionResult out, IRI defaultNamespace) throws URISyntaxException, ExtractionException {
        Literal value;
        Object propValue = itemProp.getValue().getContent();
        ItemPropValue.Type propType = itemProp.getValue().getType();
        if (itemProp.getValue().literal != null) {
            value = itemProp.getValue().literal;
        } else if (propType.equals((Object)ItemPropValue.Type.Nested)) {
            value = this.processType((ItemScope)propValue, documentIRI, out, mappings, defaultNamespace);
        } else if (propType.equals((Object)ItemPropValue.Type.Link)) {
            value = MicrodataExtractor.toAbsoluteIRI(documentIRI, (String)propValue);
            if (predicate.stringValue().equals("http://schema.org/additionalType")) {
                if (itemProp.reverse) {
                    out.writeTriple((Resource)value, RDF.TYPE, (Value)subject);
                } else {
                    out.writeTriple(subject, RDF.TYPE, (Value)value);
                }
            }
        } else {
            throw new RuntimeException("Invalid Type '" + (Object)((Object)propType) + "' for ItemPropValue with name: '" + predicate + "'");
        }
        if (itemProp.reverse) {
            out.writeTriple((Resource)value, predicate, (Value)subject);
        } else {
            out.writeTriple(subject, predicate, (Value)value);
        }
    }

    private static IRI getNamespaceIRI(IRI itemType) {
        return itemType.stringValue().startsWith(hcardPrefix) ? hcardNamespaceIRI : itemType;
    }

    private static IRI getPredicate(IRI namespaceIRI, String localName) {
        return MicrodataExtractor.toAbsoluteIRI(localName).orElseGet(() -> namespaceIRI == null ? null : RDFUtils.iri(namespaceIRI.getNamespace(), localName.trim()));
    }

    private static Optional<IRI> toAbsoluteIRI(String urlString) {
        if (urlString != null) {
            try {
                ParsedIRI iri = ParsedIRI.create((String)urlString.trim());
                if (iri.isAbsolute()) {
                    return Optional.of(RDFUtils.iri(iri.toString()));
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static IRI toAbsoluteIRI(ParsedIRI documentIRI, String part) throws URISyntaxException {
        try {
            return RDFUtils.iri(documentIRI.resolve(part.trim()));
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof URISyntaxException) {
                throw (URISyntaxException)e.getCause();
            }
            throw new URISyntaxException(String.valueOf(part), e.getClass().getName() + (e.getMessage() != null ? ": " + e.getMessage() : ""));
        }
    }

    private void notifyError(MicrodataParserException[] errors, ExtractionResult out) {
        for (MicrodataParserException mpe : errors) {
            out.notifyIssue(IssueReport.IssueLevel.ERROR, mpe.toJSON(), (long)mpe.getErrorLocationBeginRow(), (long)mpe.getErrorLocationBeginCol());
        }
    }
}

