/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html;

import java.util.List;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.TagSoupExtractionResult;
import org.apache.any23.extractor.html.DomUtils;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HReviewAggregateExtractorFactory;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.vocab.Review;
import org.apache.any23.vocab.ReviewAggregate;
import org.apache.any23.vocab.VCard;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HReviewAggregateExtractor
extends EntityBasedMicroformatExtractor {
    private static final Review vREVIEW = Review.getInstance();
    private static final ReviewAggregate vREVIEWAGG = ReviewAggregate.getInstance();
    private static final VCard vVCARD = VCard.getInstance();

    @Override
    public ExtractorDescription getDescription() {
        return HReviewAggregateExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "hreview-aggregate";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        BNode rev = this.getBlankNodeFor(node);
        out.writeTriple((Resource)rev, RDF.TYPE, (Value)HReviewAggregateExtractor.vREVIEWAGG.ReviewAggregate);
        HTMLDocument fragment = new HTMLDocument(node);
        this.addRating(fragment, (Resource)rev);
        this.addWorst(fragment, (Resource)rev);
        this.addBest(fragment, (Resource)rev);
        this.addAverage(fragment, (Resource)rev);
        this.addSummary(fragment, (Resource)rev);
        this.addType(fragment, (Resource)rev);
        this.addItem(fragment, rev);
        this.addCount(fragment, (Resource)rev);
        this.addVotes(fragment, (Resource)rev);
        TagSoupExtractionResult tser = (TagSoupExtractionResult)out;
        tser.addResourceRoot(DomUtils.getXPathListForNode(node), (Resource)rev, this.getClass());
        return true;
    }

    private void addType(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("type");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewAggregateExtractor.vREVIEW.type, value.value());
    }

    private void addItem(HTMLDocument root, BNode rev) throws ExtractionException {
        List<Node> nodes = root.findAllByClassName("item");
        for (Node node : nodes) {
            Resource item = this.findDummy(new HTMLDocument(node));
            this.addBNodeProperty(node, item, HReviewAggregateExtractor.vREVIEW.hasReview, rev);
        }
    }

    private Resource findDummy(HTMLDocument item) throws ExtractionException {
        HTMLDocument.TextField[] pics;
        BNode blank = this.getBlankNodeFor(item.getDocument());
        HTMLDocument.TextField val = item.getSingularTextField("fn");
        this.conditionallyAddStringProperty(val.source(), (Resource)blank, HReviewAggregateExtractor.vVCARD.fn, val.value());
        HTMLDocument.TextField url = item.getSingularUrlField("url");
        this.conditionallyAddResourceProperty((Resource)blank, HReviewAggregateExtractor.vVCARD.url, this.getHTMLDocument().resolveIRI(url.value()));
        for (HTMLDocument.TextField pic : pics = item.getPluralUrlField("photo")) {
            this.addIRIProperty((Resource)blank, HReviewAggregateExtractor.vVCARD.photo, this.getHTMLDocument().resolveIRI(pic.value()));
        }
        return blank;
    }

    private void addRating(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("rating");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewAggregateExtractor.vREVIEW.rating, value.value());
    }

    private void addWorst(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("worst");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewAggregateExtractor.vREVIEWAGG.worst, value.value());
    }

    private void addBest(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("best");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewAggregateExtractor.vREVIEWAGG.best, value.value());
    }

    private void addAverage(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("average");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewAggregateExtractor.vREVIEWAGG.average, value.value());
    }

    private void addCount(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("count");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewAggregateExtractor.vREVIEWAGG.count, value.value());
    }

    private void addVotes(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("votes");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewAggregateExtractor.vREVIEWAGG.votes, value.value());
    }

    private void addSummary(HTMLDocument doc, Resource rev) {
        HTMLDocument.TextField value = doc.getSingularTextField("summary");
        this.conditionallyAddStringProperty(value.source(), rev, HReviewAggregateExtractor.vREVIEW.title, value.value());
    }
}

