/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.calendar;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.io.ParseWarning;
import biweekly.io.SkipMeException;
import biweekly.io.StreamReader;
import biweekly.io.TimezoneAssignment;
import biweekly.io.TimezoneInfo;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.json.JsonValue;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.Encoding;
import biweekly.parameter.ICalParameters;
import biweekly.property.Geo;
import biweekly.property.ICalProperty;
import biweekly.util.DateTimeComponents;
import biweekly.util.ICalDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.vocab.ICAL;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

abstract class BaseCalendarExtractor
implements Extractor.ContentExtractor {
    private static final ValueFactory f = SimpleValueFactory.getInstance();
    private static final ICAL vICAL = ICAL.getInstance();
    private static final String NaN = Double.toString(Double.NaN);
    private static final Pattern durationWeeksPattern = Pattern.compile("(-?P)(\\d+)W");

    BaseCalendarExtractor() {
    }

    public void setStopAtFirstError(boolean b) {
    }

    abstract StreamReader reader(InputStream var1);

    public final void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, InputStream inputStream, ExtractionResult result) throws IOException, ExtractionException {
        result.writeNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        result.writeNamespace("ical", "http://www.w3.org/2002/12/cal/icaltzd#");
        result.writeNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
        ScribeIndex index = new ScribeIndex();
        try (StreamReader reader = this.reader(inputStream);){
            ICalendar cal;
            while ((cal = reader.readNext()) != null) {
                for (ParseWarning warning : reader.getWarnings()) {
                    String message = warning.getMessage();
                    Integer lineNumber = warning.getLineNumber();
                    if (lineNumber == null) {
                        result.notifyIssue(IssueReport.IssueLevel.WARNING, message, -1L, -1L);
                        continue;
                    }
                    result.notifyIssue(IssueReport.IssueLevel.WARNING, message, (long)lineNumber.intValue(), -1L);
                }
                BNode calNode = f.createBNode();
                result.writeTriple((Resource)calNode, RDF.TYPE, (Value)BaseCalendarExtractor.vICAL.Vcalendar);
                WriteContext ctx = new WriteContext(ICalVersion.V2_0, cal.getTimezoneInfo(), null);
                BaseCalendarExtractor.extract(index, ctx, calNode, (ICalComponent)cal, result, true);
            }
        }
        catch (Exception e) {
            result.notifyIssue(IssueReport.IssueLevel.FATAL, BaseCalendarExtractor.toString(e), -1L, -1L);
        }
    }

    private static String toString(Throwable th) {
        StringWriter writer = new StringWriter();
        try (PrintWriter pw = new PrintWriter(writer);){
            th.printStackTrace(pw);
        }
        String string = writer.toString();
        if (string.length() > 200) {
            return string.substring(0, 197) + "...";
        }
        return string;
    }

    private static String localNameOfType(String typeName) {
        return BaseCalendarExtractor.camelCase(typeName, false);
    }

    private static String localNameOfProperty(String propertyName) {
        return BaseCalendarExtractor.camelCase(propertyName, true);
    }

    private static String camelCase(String name, boolean forProperty) {
        String[] nameComponents = name.toLowerCase(Locale.ENGLISH).split("-");
        StringBuilder sb = new StringBuilder(name.length());
        int i = 0;
        if (forProperty) {
            sb.append(nameComponents[i++]);
        }
        int len = nameComponents.length;
        while (i < len) {
            String n = nameComponents[i];
            if (!n.isEmpty()) {
                int ind = Character.charCount(n.codePointAt(0));
                sb.append(n.substring(0, ind).toUpperCase(Locale.ENGLISH)).append(n.substring(ind));
            }
            ++i;
        }
        return sb.toString();
    }

    private static IRI type(String originalName) {
        if (originalName.regionMatches(true, 0, "X-", 0, 2)) {
            return f.createIRI("http://www.w3.org/2002/12/cal/icaltzd#", "X-" + BaseCalendarExtractor.localNameOfType(originalName.substring(2)));
        }
        String name = BaseCalendarExtractor.localNameOfType(originalName);
        try {
            return Objects.requireNonNull(vICAL.getClass(name));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private static IRI predicate(String originalName, ExtractionResult result) {
        if (originalName.regionMatches(true, 0, "X-", 0, 2)) {
            return f.createIRI("http://www.w3.org/2002/12/cal/icaltzd#", "x-" + BaseCalendarExtractor.localNameOfProperty(originalName.substring(2)));
        }
        String name = BaseCalendarExtractor.localNameOfProperty(originalName);
        try {
            return Objects.requireNonNull(vICAL.getProperty(name));
        }
        catch (RuntimeException e) {
            IRI iri = f.createIRI("http://www.w3.org/2002/12/cal/icaltzd#", name);
            result.notifyIssue(IssueReport.IssueLevel.ERROR, "property " + iri + " (" + originalName + ") not defined in " + ICAL.class.getName(), -1L, -1L);
            return iri;
        }
    }

    private static String str(Double d) {
        return d == null ? NaN : d.toString();
    }

    private static BNode writeParams(BNode subject, IRI predicate, ICalParameters params, ExtractionResult result) {
        BNode bNode = f.createBNode();
        result.writeTriple((Resource)subject, predicate, (Value)bNode);
        BaseCalendarExtractor.writeParams(bNode, params, result);
        return bNode;
    }

    private static void writeParams(BNode subject, ICalParameters params, ExtractionResult result) {
        for (Map.Entry entry : params.getMap().entrySet()) {
            List strings = (List)entry.getValue();
            if (strings == null || strings.isEmpty()) continue;
            IRI predicate = BaseCalendarExtractor.predicate((String)entry.getKey(), result);
            for (String v : strings) {
                result.writeTriple((Resource)subject, predicate, (Value)f.createLiteral(v));
            }
        }
    }

    private static IRI dataType(ICalDataType dataType, Boolean isFloating) {
        if (dataType == null || ICalDataType.TEXT.equals(dataType)) {
            return XMLSchema.STRING;
        }
        if (ICalDataType.BOOLEAN.equals(dataType)) {
            return XMLSchema.BOOLEAN;
        }
        if (ICalDataType.INTEGER.equals(dataType)) {
            return XMLSchema.INTEGER;
        }
        if (ICalDataType.FLOAT.equals(dataType)) {
            return XMLSchema.FLOAT;
        }
        if (ICalDataType.BINARY.equals(dataType)) {
            return XMLSchema.BASE64BINARY;
        }
        if (ICalDataType.URI.equals(dataType) || ICalDataType.URL.equals(dataType) || ICalDataType.CONTENT_ID.equals(dataType) || ICalDataType.CAL_ADDRESS.equals(dataType)) {
            return XMLSchema.ANYURI;
        }
        if (ICalDataType.DATE_TIME.equals(dataType)) {
            if (isFloating == null) {
                return null;
            }
            return isFloating != false ? BaseCalendarExtractor.vICAL.DATE_TIME : XMLSchema.DATETIME;
        }
        if (ICalDataType.DATE.equals(dataType)) {
            return XMLSchema.DATE;
        }
        if (ICalDataType.TIME.equals(dataType)) {
            return XMLSchema.TIME;
        }
        if (ICalDataType.DURATION.equals(dataType)) {
            return XMLSchema.DURATION;
        }
        if (ICalDataType.PERIOD.equals(dataType)) {
            return BaseCalendarExtractor.vICAL.Value_PERIOD;
        }
        if (ICalDataType.RECUR.equals(dataType)) {
            return BaseCalendarExtractor.vICAL.Value_RECUR;
        }
        return XMLSchema.STRING;
    }

    private static String normalizeAndReportIfInvalid(String s, IRI dataType, TimeZone zone, ExtractionResult result) {
        if (dataType == null) {
            return s;
        }
        try {
            if (XMLSchema.DURATION.equals((Object)dataType)) {
                Matcher m = durationWeeksPattern.matcher(s);
                if (m.matches()) {
                    long days = Long.parseLong(m.group(2)) * 7L;
                    return m.group(1) + days + "D";
                }
            } else if (BaseCalendarExtractor.vICAL.Value_PERIOD.equals((Object)dataType)) {
                if (s.indexOf(47) == -1) {
                    throw new IllegalArgumentException();
                }
            } else if (zone != null && XMLSchema.DATETIME.equals((Object)dataType)) {
                try {
                    DateTimeComponents dt = DateTimeComponents.parse((String)s);
                    if (!dt.isUtc()) {
                        s = ICalDateFormat.DATE_TIME_EXTENDED.format(dt.toDate(zone), zone);
                    }
                }
                catch (IllegalArgumentException dt) {}
            } else {
                s = XMLDatatypeUtil.normalize((String)s, (IRI)dataType);
            }
            if (!XMLDatatypeUtil.isValidValue((String)s, (IRI)dataType)) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException e) {
            String m = e.getMessage();
            if (StringUtils.isBlank((CharSequence)m)) {
                m = "Not a valid " + dataType + " value: " + s;
            }
            result.notifyIssue(IssueReport.IssueLevel.ERROR, m, -1L, -1L);
        }
        return s;
    }

    private static boolean writeValue(BNode subject, IRI predicate, JsonValue jsonValue, String lang, IRI dataType, TimeZone zone, ExtractionResult result) {
        if (jsonValue == null || jsonValue.isNull()) {
            return false;
        }
        Object val = jsonValue.getValue();
        if (val != null) {
            Literal v;
            if (val instanceof Byte) {
                v = f.createLiteral(((Byte)val).byteValue());
            } else if (val instanceof Short) {
                v = f.createLiteral(((Short)val).shortValue());
            } else if (val instanceof Integer) {
                v = f.createLiteral(((Integer)val).intValue());
            } else if (val instanceof Long) {
                v = f.createLiteral(((Long)val).longValue());
            } else if (val instanceof Float) {
                v = f.createLiteral(((Float)val).floatValue());
            } else if (val instanceof Double) {
                v = f.createLiteral(((Double)val).doubleValue());
            } else if (val instanceof Boolean) {
                v = f.createLiteral(((Boolean)val).booleanValue());
            } else if (val instanceof BigInteger) {
                v = f.createLiteral((BigInteger)val);
            } else if (val instanceof BigDecimal) {
                v = f.createLiteral((BigDecimal)val);
            } else {
                String str = BaseCalendarExtractor.normalizeAndReportIfInvalid(val.toString(), dataType, zone, result);
                if (XMLSchema.STRING.equals((Object)dataType)) {
                    v = lang == null ? f.createLiteral(str) : f.createLiteral(str, lang);
                } else if (XMLSchema.ANYURI.equals((Object)dataType)) {
                    try {
                        v = f.createIRI(str);
                    }
                    catch (IllegalArgumentException e) {
                        v = f.createLiteral(str, dataType);
                    }
                } else if (BaseCalendarExtractor.vICAL.Value_PERIOD.equals((Object)dataType)) {
                    String[] strs = str.split("/");
                    if (strs.length == 2) {
                        String firstPart = BaseCalendarExtractor.normalizeAndReportIfInvalid(strs[0], XMLSchema.DATETIME, zone, result);
                        String secondPart = strs[1];
                        secondPart = secondPart.indexOf(80) != -1 ? BaseCalendarExtractor.normalizeAndReportIfInvalid(secondPart, XMLSchema.DURATION, zone, result) : BaseCalendarExtractor.normalizeAndReportIfInvalid(secondPart, XMLSchema.DATETIME, zone, result);
                        str = firstPart + "/" + secondPart;
                    }
                    v = f.createLiteral(str);
                } else {
                    v = dataType != null ? f.createLiteral(str, dataType) : f.createLiteral(str);
                }
            }
            result.writeTriple((Resource)subject, predicate, (Value)v);
            return true;
        }
        List array = jsonValue.getArray();
        if (array != null && !array.isEmpty()) {
            if (array.size() == 1) {
                return BaseCalendarExtractor.writeValue(subject, predicate, (JsonValue)array.get(0), lang, dataType, zone, result);
            }
            BNode bNode = f.createBNode();
            result.writeTriple((Resource)subject, predicate, (Value)bNode);
            for (JsonValue value : array) {
                BaseCalendarExtractor.writeValue(bNode, RDF.VALUE, value, lang, dataType, zone, result);
            }
            return true;
        }
        Map object = jsonValue.getObject();
        if (object != null) {
            BNode bNode = f.createBNode();
            result.writeTriple((Resource)subject, predicate, (Value)bNode);
            for (Map.Entry entry : object.entrySet()) {
                BaseCalendarExtractor.writeValue(bNode, BaseCalendarExtractor.predicate((String)entry.getKey(), result), (JsonValue)entry.getValue(), lang, XMLSchema.STRING, zone, result);
            }
            return true;
        }
        return false;
    }

    private static TimeZone parseTimeZoneId(String tzId) {
        TimeZone zone;
        while ((zone = ICalDateFormat.parseTimeZoneId((String)tzId)) == null) {
            int ind = tzId.indexOf(47);
            if (ind == -1) {
                return null;
            }
            tzId = tzId.substring(ind + 1);
        }
        return zone;
    }

    private static <T extends ICalProperty> void writeProperty(BNode subject, ICalPropertyScribe<T> scribe, ICalProperty property, WriteContext ctx, ExtractionResult result) {
        try {
            ICalProperty prop = property;
            ICalVersion version = ctx.getVersion();
            ICalDataType dataType = scribe.dataType(prop, version);
            ICalParameters params = scribe.prepareParameters(prop, ctx);
            String lang = params.getLanguage();
            params.removeAll((Object)"LANGUAGE");
            Encoding encoding = params.getEncoding();
            if (dataType == null && (dataType = params.getValue()) == null && Encoding.BASE64.equals(encoding)) {
                dataType = ICalDataType.BINARY;
            }
            params.removeAll((Object)"VALUE");
            if (ICalDataType.BINARY.equals(dataType)) {
                if (encoding != null && !Encoding.BASE64.equals(encoding)) {
                    result.notifyIssue(IssueReport.IssueLevel.ERROR, "Invalid encoding " + encoding + " specified for BINARY value", -1L, -1L);
                    dataType = null;
                }
                params.removeAll((Object)"ENCODING");
            }
            if (Encoding._8BIT.equals(encoding)) {
                params.removeAll((Object)"ENCODING");
            }
            params.removeAll((Object)"CHARSET");
            IRI predicate = BaseCalendarExtractor.predicate(scribe.getPropertyName(version), result);
            if (ICalDataType.CAL_ADDRESS.equals(dataType)) {
                subject = BaseCalendarExtractor.writeParams(subject, predicate, params, result);
                predicate = BaseCalendarExtractor.vICAL.calAddress;
            } else if (!params.isEmpty()) {
                subject = BaseCalendarExtractor.writeParams(subject, predicate, params, result);
                predicate = RDF.VALUE;
            }
            if (prop instanceof Geo) {
                Geo g = (Geo)prop;
                IRI value = f.createIRI("geo:" + BaseCalendarExtractor.str(g.getLatitude()) + "," + BaseCalendarExtractor.str(g.getLongitude()));
                result.writeTriple((Resource)subject, predicate, (Value)value);
            } else {
                Boolean floating;
                String tzId = params.getTimezoneId();
                TimezoneInfo tzInfo = ctx.getTimezoneInfo();
                TimeZone timeZone = null;
                if (tzId != null) {
                    TimezoneAssignment assign = tzInfo.getTimezone(prop);
                    if (assign != null) {
                        timeZone = assign.getTimeZone();
                    } else {
                        timeZone = BaseCalendarExtractor.parseTimeZoneId(tzId);
                        tzInfo.setFloating(prop, true);
                    }
                    floating = timeZone == null ? null : Boolean.FALSE;
                } else {
                    floating = tzInfo.isFloating(prop);
                }
                IRI dataTypeIRI = BaseCalendarExtractor.dataType(dataType, floating);
                JCalValue jsonVal = scribe.writeJson(prop, ctx);
                List jsonVals = jsonVal.getValues();
                boolean mod = false;
                for (JsonValue value : jsonVals) {
                    mod |= BaseCalendarExtractor.writeValue(subject, predicate, value, lang, dataTypeIRI, timeZone, result);
                }
                if (!mod) {
                    result.writeTriple((Resource)subject, predicate, (Value)f.createLiteral(jsonVal.asSingle()));
                }
            }
        }
        catch (SkipMeException skipMeException) {
            // empty catch block
        }
    }

    private static void extract(ScribeIndex index, WriteContext ctx, BNode node, ICalComponent component, ExtractionResult result, boolean writeTimezones) {
        for (ICalProperty property : component.getProperties().values()) {
            ctx.setParent(component);
            BaseCalendarExtractor.writeProperty(node, index.getPropertyScribe(property), property, ctx, result);
        }
        Stream<Object> components = component.getComponents().values().stream();
        if (writeTimezones) {
            Collection tzs = ctx.getTimezoneInfo().getComponents();
            Set tzIds = tzs.stream().map(tz -> (String)tz.getTimezoneId().getValue()).collect(Collectors.toSet());
            components = Stream.concat(tzs.stream(), components.filter(c -> !(c instanceof VTimezone) || !tzIds.contains(((VTimezone)c).getTimezoneId().getValue())));
        }
        components.forEachOrdered(child -> {
            BNode childNode = f.createBNode();
            String componentName = index.getComponentScribe(child).getComponentName();
            IRI childType = BaseCalendarExtractor.type(componentName);
            if (childType == null) {
                result.writeTriple((Resource)node, BaseCalendarExtractor.predicate(componentName, result), (Value)childNode);
            } else {
                result.writeTriple((Resource)node, BaseCalendarExtractor.vICAL.component, (Value)childNode);
                result.writeTriple((Resource)childNode, RDF.TYPE, (Value)childType);
            }
            BaseCalendarExtractor.extract(index, ctx, childNode, child, result, false);
        });
    }
}

