/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import uk.ac.manchester.cs.factplusplusad.LocalityChecker;
import uk.ac.manchester.cs.factplusplusad.Signature;

class SemanticLocalityChecker
extends LocalityChecker {
    OWLReasoner kernel;
    Map<OWLAxiom, Collection<OWLClassExpression>> exprMap = new HashMap<OWLAxiom, Collection<OWLClassExpression>>();
    private final OWLOntologyManager manager;
    private final OWLDataFactory df;
    private final OWLReasonerFactory factory;
    private final ExpressionManager expressionManager;

    SemanticLocalityChecker(Signature sig, OWLOntologyManager m, OWLReasonerFactory factory) {
        super(sig);
        this.manager = m;
        this.df = this.manager.getOWLDataFactory();
        this.factory = factory;
        this.expressionManager = new ExpressionManager(this.df);
    }

    Stream<OWLClassExpression> getExpr(OWLAxiom axiom) {
        OWLClassExpression e = (OWLClassExpression)axiom.accept((OWLAxiomVisitorEx)this.expressionManager);
        return Stream.of(e).filter(Objects::nonNull);
    }

    @Override
    public void preprocessOntology(Collection<AxiomWrapper> axioms) {
        this.exprMap.clear();
        Signature s = new Signature();
        for (AxiomWrapper q : axioms) {
            if (!q.isUsed()) continue;
            this.exprMap.put(q.getAxiom(), OWLAPIStreamUtils.asList(this.getExpr(q.getAxiom())));
            s.addAll(q.getAxiom().signature());
        }
        HashSet declarationAxioms = new HashSet();
        s.getSignature().map(arg_0 -> ((OWLDataFactory)this.df).getOWLDeclarationAxiom(arg_0)).forEach(declarationAxioms::add);
        try {
            this.kernel = this.factory.createReasoner(this.manager.createOntology(declarationAxioms));
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        this.kernel.precomputeInferences(new InferenceType[]{InferenceType.CLASS_HIERARCHY});
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.isLocal = true;
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.isLocal = false;
        if (OWLAPIStreamUtils.pairs((Stream)axiom.classExpressions()).map(v -> this.df.getOWLEquivalentClassesAxiom((OWLClassExpression)v.i, (OWLClassExpression)v.j)).anyMatch(ax -> !this.kernel.isEntailed((OWLAxiom)ax))) {
            return;
        }
        this.isLocal = true;
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        this.isLocal = false;
        if (OWLAPIStreamUtils.pairs((Stream)axiom.classExpressions()).map(v -> this.df.getOWLDisjointClassesAxiom(new OWLClassExpression[]{(OWLClassExpression)v.i, (OWLClassExpression)v.j})).anyMatch(ax -> !this.kernel.isEntailed((OWLAxiom)ax))) {
            return;
        }
        this.isLocal = true;
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.isLocal = false;
        if (!this.kernel.isEntailed((OWLAxiom)this.df.getOWLEquivalentClassesAxiom((OWLClassExpression)axiom.getOWLClass(), (OWLClassExpression)this.df.getOWLObjectIntersectionOf(axiom.classExpressions())))) {
            return;
        }
        if (OWLAPIStreamUtils.pairs((Stream)axiom.classExpressions()).anyMatch(v -> !this.kernel.isEntailed((OWLAxiom)this.df.getOWLDisjointClassesAxiom(new OWLClassExpression[]{(OWLClassExpression)v.i, (OWLClassExpression)v.j})))) {
            return;
        }
        this.isLocal = true;
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.isLocal = false;
        if (OWLAPIStreamUtils.pairs((Stream)axiom.properties()).map(v -> this.df.getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)v.i, (OWLObjectPropertyExpression)v.j)).anyMatch(ax -> !this.kernel.isEntailed((OWLAxiom)ax))) {
            return;
        }
        this.isLocal = true;
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.isLocal = false;
        if (OWLAPIStreamUtils.pairs((Stream)axiom.properties()).map(v -> this.df.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)v.i, (OWLDataPropertyExpression)v.j)).anyMatch(ax -> !this.kernel.isEntailed((OWLAxiom)ax))) {
            return;
        }
        this.isLocal = true;
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        this.isLocal = false;
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.isLocal = false;
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom(axiom.getFirstProperty(), axiom.getSecondProperty().getInverseProperty())) && this.kernel.isEntailed((OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom(axiom.getFirstProperty().getInverseProperty(), axiom.getSecondProperty()));
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.isLocal = true;
        for (OWLClassExpression e : this.exprMap.get(axiom)) {
            this.isLocal &= this.kernel.isEntailed((OWLAxiom)this.df.getOWLSubClassOfAxiom(e, (OWLClassExpression)axiom.getDomain()));
        }
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.isLocal = true;
        for (OWLClassExpression e : this.exprMap.get(axiom)) {
            this.isLocal &= this.kernel.isEntailed((OWLAxiom)this.df.getOWLSubClassOfAxiom(e, (OWLClassExpression)axiom.getDomain()));
        }
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.isLocal = true;
        for (OWLClassExpression e : this.exprMap.get(axiom)) {
            this.isLocal &= !this.kernel.isSatisfiable(e);
        }
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.isLocal = true;
        for (OWLClassExpression e : this.exprMap.get(axiom)) {
            this.isLocal &= !this.kernel.isSatisfiable(e);
        }
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    static class ExpressionManager
    implements OWLAxiomVisitorEx<OWLClassExpression> {
        private final OWLDataFactory df;

        public ExpressionManager(OWLDataFactory df) {
            this.df = df;
        }

        public OWLClassExpression visit(OWLObjectPropertyAssertionAxiom ax) {
            return this.df.getOWLObjectHasValue((OWLObjectPropertyExpression)ax.getProperty(), (OWLIndividual)ax.getObject());
        }

        public OWLClassExpression visit(OWLDataPropertyAssertionAxiom ax) {
            return this.df.getOWLDataHasValue((OWLDataPropertyExpression)ax.getProperty(), (OWLLiteral)ax.getObject());
        }

        public OWLClassExpression visit(OWLObjectPropertyDomainAxiom ax) {
            return this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)ax.getProperty(), (OWLClassExpression)this.df.getOWLThing());
        }

        public OWLClassExpression visit(OWLObjectPropertyRangeAxiom ax) {
            return this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)ax.getProperty(), (OWLClassExpression)ax.getRange());
        }

        public OWLClassExpression visit(OWLDataPropertyDomainAxiom ax) {
            return this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)ax.getProperty(), (OWLDataRange)this.df.getTopDatatype());
        }

        public OWLClassExpression visit(OWLDataPropertyRangeAxiom ax) {
            return this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)ax.getProperty(), (OWLDataRange)this.df.getOWLDataComplementOf((OWLDataRange)ax.getRange()));
        }

        public OWLClassExpression visit(OWLNegativeObjectPropertyAssertionAxiom ax) {
            return this.df.getOWLObjectComplementOf((OWLClassExpression)this.df.getOWLObjectHasValue((OWLObjectPropertyExpression)ax.getProperty(), (OWLIndividual)ax.getObject()));
        }

        public OWLClassExpression visit(OWLNegativeDataPropertyAssertionAxiom ax) {
            return this.df.getOWLObjectComplementOf((OWLClassExpression)this.df.getOWLDataHasValue((OWLDataPropertyExpression)ax.getProperty(), (OWLLiteral)ax.getObject()));
        }
    }
}

