/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.lang.reflect.Array;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.internal.feature.DateList;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.iso.Names;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

public final class MovingFeature {
    public static final DefaultAttributeType<Instant> TIME;
    private final Period[] properties;
    private final int[] count;
    private long tmin = Long.MAX_VALUE;
    private long tmax = Long.MIN_VALUE;

    public MovingFeature(int n) {
        this.properties = new Period[n];
        this.count = new int[n];
    }

    public final void addTimeRange(long l, long l2) {
        if (l < this.tmin) {
            this.tmin = l;
        }
        if (l2 > this.tmax) {
            this.tmax = l2;
        }
    }

    public final void addValue(int n, long l, long l2, Object object) {
        Period period = this.properties[n];
        if (period != null && period.endTime == l && Objects.equals(period.value, object)) {
            period.endTime = l2;
        } else {
            this.properties[n] = new Period(period, l, l2, object);
            int n2 = n;
            this.count[n2] = this.count[n2] + 1;
        }
    }

    public final void storeTimeRange(String string, String string2, AbstractFeature abstractFeature) {
        if (this.tmin < this.tmax) {
            Instant instant = Instant.ofEpochMilli(this.tmin);
            abstractFeature.setPropertyValue(string, instant);
            abstractFeature.setPropertyValue(string2, this.tmin == this.tmax ? instant : Instant.ofEpochMilli(this.tmax));
        }
    }

    public final <V> void storeAttribute(int n, AbstractAttribute<V> abstractAttribute) {
        int n2 = this.count[n];
        long[] lArray = new long[n2];
        Object[] objectArray = (Object[])Array.newInstance(abstractAttribute.getType().getValueClass(), n2);
        Object object = this.properties[n];
        while (object != null) {
            lArray[--n2] = ((Period)object).startTime;
            objectArray[n2] = ((Period)object).value;
            object = ((Period)object).previous;
        }
        if (n2 != 0) {
            throw new CorruptedObjectException();
        }
        abstractAttribute.setValues(UnmodifiableArrayList.wrap(objectArray));
        object = TIME.newInstance();
        ((AbstractAttribute)object).setValues(new DateList(lArray));
        abstractAttribute.characteristics().values().add((AbstractAttribute<?>)object);
    }

    public final <G> void storeGeometry(String string, int n, int n2, Geometries<G> geometries, AbstractAttribute<G> abstractAttribute, Consumer<LogRecord> consumer) {
        int n3;
        Object object;
        Object object2;
        int n4;
        int n5 = this.count[n];
        Vector[] vectorArray = new Vector[n5];
        Period period = this.properties[n];
        while (period != null) {
            vectorArray[--n5] = Vector.create(period.value, false);
            period = period.previous;
        }
        if (n5 != 0) {
            throw new CorruptedObjectException();
        }
        int n6 = 10;
        int n7 = 0;
        Object object3 = null;
        for (n4 = 0; n4 < vectorArray.length; ++n4) {
            int n8;
            object2 = vectorArray[n4];
            if (object2 == null || (n8 = ((Vector)object2).size()) == 0) continue;
            if (n8 % n2 != 0) {
                if (--n6 < 0) continue;
                object = this.properties[n];
                n3 = n4;
                while (--n3 >= 0) {
                    object = ((Period)object).previous;
                }
                consumer.accept(Resources.forLocale(null).getLogRecord(Level.WARNING, (short)22, string, new Date(((Period)object).startTime), n2, n8));
                continue;
            }
            if (object3 != null && MovingFeature.equals(object3, (Vector)object2, n2)) {
                object2 = ((Vector)object2).subList(n2, n8);
                if ((n8 -= n2) == 0) {
                    vectorArray[n4] = null;
                    continue;
                }
                vectorArray[n4] = object2;
            }
            n7 += n8;
            object3 = object2;
        }
        n4 = vectorArray.length;
        object2 = new long[n7 /= n2];
        Object object4 = this.properties[n];
        while (object4 != null) {
            if ((object = vectorArray[--n4]) != null) {
                n3 = ((Vector)object).size() / n2;
                if (n3 == 1) {
                    object2[--n7] = ((Period)object4).endTime;
                } else {
                    long l = ((Period)object4).startTime;
                    double d = (double)(((Period)object4).endTime - l) / (double)(n3 - 1);
                    while (--n3 >= 0) {
                        object2[--n7] = l + Math.round(d * (double)n3);
                    }
                }
            }
            object4 = ((Period)object4).previous;
        }
        if (n7 != 0) {
            throw new CorruptedObjectException();
        }
        abstractAttribute.setValue(geometries.createPolyline(n2, vectorArray));
        object4 = TIME.newInstance();
        ((AbstractAttribute)object4).setValues(new DateList((long[])object2));
        abstractAttribute.characteristics().values().add((AbstractAttribute<?>)object4);
    }

    private static boolean equals(Vector vector, Vector vector2, int n) {
        int n2 = vector.size();
        while (--n >= 0) {
            if (vector2.doubleValue(n) == vector.doubleValue(--n2)) continue;
            return false;
        }
        return true;
    }

    static {
        LocalName localName = Names.createLocalName("OGC", null, "MF");
        HashMap<String, ScopedName> hashMap = new HashMap<String, ScopedName>(4);
        hashMap.put("name", Names.createScopedName((GenericName)localName, null, "datetimes"));
        TIME = new DefaultAttributeType<Object>(hashMap, Instant.class, 0, Integer.MAX_VALUE, null, new DefaultAttributeType[0]);
    }

    private static final class Period {
        final long startTime;
        long endTime;
        final Object value;
        final Period previous;

        Period(Period period, long l, long l2, Object object) {
            this.previous = period;
            this.startTime = l;
            this.endTime = l2;
            this.value = object;
        }
    }
}

