/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.referencing.provider.LambertCylindricalEqualArea;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.EqualAreaProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class CylindricalEqualArea
extends EqualAreaProjection {
    private static final long serialVersionUID = 8840395516658904421L;
    private final byte variant;

    private static byte getVariant(OperationMethod operationMethod) {
        if (CylindricalEqualArea.identMatch(operationMethod, "(?i).*\\bSpherical\\b.*", "9834")) {
            return -128;
        }
        return 0;
    }

    public CylindricalEqualArea(OperationMethod operationMethod, Parameters parameters) {
        this(CylindricalEqualArea.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, LambertCylindricalEqualArea.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, LambertCylindricalEqualArea.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, CylindricalEqualArea.getVariant(operationMethod));
    }

    private CylindricalEqualArea(Initializer initializer) {
        super(initializer);
        this.variant = initializer.variant;
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        double d = initializer.getAndStore(LambertCylindricalEqualArea.LONGITUDE_OF_ORIGIN);
        if (d != 0.0) {
            DoubleDouble doubleDouble = DoubleDouble.createDegreesToRadians();
            doubleDouble.multiplyGuessError(-d);
            matrixSIS.convertBefore(0, null, doubleDouble);
        }
        double d2 = Math.toRadians(initializer.getAndStore(LambertCylindricalEqualArea.STANDARD_PARALLEL));
        DoubleDouble doubleDouble = new DoubleDouble(initializer.scaleAt\u03c6(Math.sin(d2), Math.cos(d2)));
        doubleDouble.multiplyGuessError(initializer.getAndStore(Mercator1SP.SCALE_FACTOR));
        DoubleDouble doubleDouble2 = new DoubleDouble(1.0);
        doubleDouble2.subtract(initializer.eccentricitySquared);
        doubleDouble2.multiply(0.5);
        doubleDouble2.divide(doubleDouble);
        matrixSIS.convertAfter(0, doubleDouble, null);
        matrixSIS.convertAfter(1, doubleDouble2, null);
    }

    CylindricalEqualArea(CylindricalEqualArea cylindricalEqualArea) {
        super(cylindricalEqualArea);
        this.variant = cylindricalEqualArea.variant;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        CylindricalEqualArea cylindricalEqualArea = this;
        if (this.variant == -128 || this.eccentricity == 0.0) {
            cylindricalEqualArea = new Spherical(this);
        }
        return this.context.completeTransform(mathTransformFactory, cylindricalEqualArea);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n + 1];
        double d2 = Math.sin(d);
        if (dArray2 != null) {
            dArray2[n2] = dArray[n];
            dArray2[n2 + 1] = this.qm_ellipsoid(d2);
        }
        return bl ? new Matrix2(1.0, 0.0, 0.0, this.dqm_d\u03c6(d2, Math.cos(d))) : null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (dArray != dArray2 || n != n2 || this.getClass() != CylindricalEqualArea.class) {
            super.transform(dArray, n, dArray2, n2, n3);
        } else {
            --n2;
            while (--n3 >= 0) {
                double d = dArray2[n2 += 2];
                dArray2[n2] = this.qm_ellipsoid(Math.sin(d));
            }
        }
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n + 1];
        dArray2[n2] = dArray[n];
        dArray2[n2 + 1] = this.\u03c6(d);
    }

    private static final class Spherical
    extends CylindricalEqualArea {
        private static final long serialVersionUID = 1063449347697947732L;

        Spherical(CylindricalEqualArea cylindricalEqualArea) {
            super(cylindricalEqualArea);
            this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).convertAfter(1, 2, null);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
            double d = dArray[n + 1];
            if (dArray2 != null) {
                dArray2[n2] = dArray[n];
                dArray2[n2 + 1] = Math.sin(d);
            }
            return bl ? new Matrix2(1.0, 0.0, 0.0, Math.cos(d)) : null;
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            if (dArray != dArray2 || n != n2) {
                super.transform(dArray, n, dArray2, n2, n3);
            } else {
                --n2;
                while (--n3 >= 0) {
                    double d = dArray2[n2 += 2];
                    dArray2[n2] = Math.sin(d);
                }
            }
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) {
            double d = dArray[n + 1];
            dArray2[n2] = dArray[n];
            dArray2[n2 + 1] = Math.asin(d);
        }
    }
}

