/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.provider.DatumShiftGridCompressed;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.referencing.provider.DatumShiftGridLoader;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.operation.transform.InterpolatedGeocentricTransform;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public class FranceGeocentricInterpolation
extends GeodeticOperation {
    private static final long serialVersionUID = -4707304160205218546L;
    public static final double TX = 168.0;
    public static final double TY = 60.0;
    public static final double TZ = -320.0;
    static final double PRECISION = 1.0E-4;
    private static final double[] ACCURACY = new double[]{0.05, 0.1, 0.2, 0.5, 1.0};
    private static final String HEADER = "GR3D";
    private static final String DEFAULT = "gr3df97a.txt";
    public static final ParameterDescriptor<Path> FILE;
    public static final ParameterDescriptorGroup PARAMETERS;

    public FranceGeocentricInterpolation() {
        this(2, 2, PARAMETERS, new FranceGeocentricInterpolation[4]);
        this.redimensioned[0] = this;
        this.redimensioned[1] = new FranceGeocentricInterpolation(2, 3, PARAMETERS, this.redimensioned);
        this.redimensioned[2] = new FranceGeocentricInterpolation(3, 2, PARAMETERS, this.redimensioned);
        this.redimensioned[3] = new FranceGeocentricInterpolation(3, 3, PARAMETERS, this.redimensioned);
    }

    FranceGeocentricInterpolation(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup, GeodeticOperation[] geodeticOperationArray) {
        super(n, n2, parameterDescriptorGroup, geodeticOperationArray);
    }

    public static boolean isRecognized(Path path) {
        return path.getFileName().toString().regionMatches(true, 0, DEFAULT, 0, 5);
    }

    @Override
    public final boolean isInvertible() {
        return false;
    }

    @Override
    public int getEllipsoidsMask() {
        return 3;
    }

    private static Ellipsoid createEllipsoid(Parameters parameters, ParameterDescriptor<Double> parameterDescriptor, ParameterDescriptor<Double> parameterDescriptor2, Ellipsoid ellipsoid) {
        double d = parameters.doubleValue(parameterDescriptor);
        double d2 = parameters.doubleValue(parameterDescriptor2);
        if (ellipsoid != null && Math.abs(ellipsoid.getSemiMajorAxis() - d) < 1.0E-6 && Math.abs(ellipsoid.getSemiMinorAxis() - d2) < 1.0E-6) {
            return ellipsoid;
        }
        return DefaultEllipsoid.createEllipsoid(Collections.singletonMap("name", NilReferencingObject.UNNAMED), d, d2, Units.METRE);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException, FactoryException {
        double[] dArray;
        Path path;
        boolean bl = false;
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        Integer n = (Integer)parameters.getValue(Molodensky.DIMENSION);
        if (n != null) {
            switch (n) {
                case 2: {
                    break;
                }
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    throw new InvalidParameterValueException(Errors.format((short)45, "dim", n), "dim", (Object)n);
                }
            }
        }
        if (FranceGeocentricInterpolation.isRecognized(path = parameters.getMandatoryValue(FILE))) {
            double[] dArray2 = new double[3];
            dArray2[0] = 168.0;
            dArray2[1] = 60.0;
            dArray = dArray2;
            dArray2[2] = -320.0;
        } else {
            dArray = null;
        }
        DatumShiftGridFile<Angle, Length> datumShiftGridFile = FranceGeocentricInterpolation.getOrLoad(path, dArray, 1.0E-4);
        MathTransform mathTransform = this.createGeodeticTransformation(mathTransformFactory, FranceGeocentricInterpolation.createEllipsoid(parameters, (ParameterDescriptor<Double>)Molodensky.TGT_SEMI_MAJOR, (ParameterDescriptor<Double>)Molodensky.TGT_SEMI_MINOR, CommonCRS.ETRS89.ellipsoid()), FranceGeocentricInterpolation.createEllipsoid(parameters, (ParameterDescriptor<Double>)Molodensky.SRC_SEMI_MAJOR, (ParameterDescriptor<Double>)Molodensky.SRC_SEMI_MINOR, null), bl, datumShiftGridFile);
        try {
            mathTransform = mathTransform.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new FactoryException((Throwable)noninvertibleTransformException);
        }
        return mathTransform;
    }

    MathTransform createGeodeticTransformation(MathTransformFactory mathTransformFactory, Ellipsoid ellipsoid, Ellipsoid ellipsoid2, boolean bl, DatumShiftGridFile<Angle, Length> datumShiftGridFile) throws FactoryException {
        return InterpolatedGeocentricTransform.createGeodeticTransformation(mathTransformFactory, ellipsoid, bl, ellipsoid2, bl, datumShiftGridFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatumShiftGridFile<Angle, Length> getOrLoad(Path path, double[] dArray, double d) throws FactoryException {
        DatumShiftGridFile<Object, Object> datumShiftGridFile;
        block12: {
            Path path2 = DataDirectory.DATUM_CHANGES.resolve(path).toAbsolutePath();
            datumShiftGridFile = DatumShiftGridFile.CACHE.peek(path2);
            if (datumShiftGridFile == null) {
                Cache.Handler<DatumShiftGridFile<?, ?>> handler = DatumShiftGridFile.CACHE.lock(path2);
                try {
                    datumShiftGridFile = handler.peek();
                    if (datumShiftGridFile != null) break block12;
                    try (BufferedReader bufferedReader = Files.newBufferedReader(path2);){
                        DatumShiftGridLoader.log(FranceGeocentricInterpolation.class, path);
                        DatumShiftGridFile.Float<Angle, Length> float_ = FranceGeocentricInterpolation.load(bufferedReader, path);
                        datumShiftGridFile = DatumShiftGridCompressed.compress(float_, dArray, d);
                    }
                    catch (IOException | RuntimeException | NoninvertibleTransformException throwable) {
                        throw DatumShiftGridLoader.canNotLoad(HEADER, path, (Exception)throwable);
                    }
                    datumShiftGridFile = datumShiftGridFile.useSharedData();
                }
                finally {
                    handler.putAndUnlock(datumShiftGridFile);
                }
            }
        }
        return datumShiftGridFile.castTo(Angle.class, Length.class);
    }

    static DatumShiftGridFile.Float<Angle, Length> load(BufferedReader bufferedReader, Path path) throws IOException, FactoryException, NoninvertibleTransformException {
        Object object;
        String string;
        DatumShiftGridFile.Float<Angle, Length> float_ = null;
        Object object2 = 0.0;
        Object object3 = 0.0;
        Object object4 = 0.0;
        Object object5 = 0.0;
        Object object6 = 0.0;
        Object object7 = 0.0;
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3;
            if ((string = bufferedReader.readLine()) == null) {
                throw new EOFException(Errors.format((short)137, path));
            }
            int n4 = CharSequences.skipTrailingWhitespaces(string, 0, string.length());
            if (n4 <= 0 || string.charAt(n3 = CharSequences.skipLeadingWhitespaces(string, 0, n4)) == '#') continue;
            if (!string.regionMatches(true, n3, HEADER, 0, HEADER.length())) break;
            if ((n3 += HEADER.length()) >= n4) continue;
            char c = string.charAt(n3);
            n3 = CharSequences.skipLeadingWhitespaces(string, n3 + 1, n4);
            switch (c) {
                case '1': {
                    if (float_ != null) {
                        throw new FactoryException(Errors.format((short)24, HEADER));
                    }
                    object = CharSequences.parseDoubles(string.substring(n3, n4), ' ');
                    if (((Object)object).length != 6) break;
                    object2 = object[0];
                    object3 = object[1];
                    object4 = object[2];
                    object5 = object[3];
                    object6 = object[4];
                    object7 = object[5];
                    n = Math.toIntExact(Math.round((object3 - object2) / object6 + 1.0));
                    n2 = Math.toIntExact(Math.round((object5 - object4) / object7 + 1.0));
                    float_ = new DatumShiftGridFile.Float<Angle, Length>(3, Units.DEGREE, Units.METRE, false, (double)object2, (double)object4, (double)object6, (double)object7, n, n2, PARAMETERS, new Path[]{path});
                    break;
                }
                case '2': {
                    object = string.substring(n3, n4);
                    if (((String)object).matches("(?i)INTERPOLATION[^A-Z]+BILINEAIRE")) break;
                    LogRecord logRecord = Errors.getResources((Locale)null).getLogRecord(Level.WARNING, (short)161, object);
                    logRecord.setLoggerName("org.apache.sis.referencing.operation");
                    Logging.log(FranceGeocentricInterpolation.class, "createMathTransform", logRecord);
                    break;
                }
            }
        }
        if (float_ == null) {
            throw new FactoryException(Errors.format((short)10, HEADER, path));
        }
        float[] fArray = float_.offsets[0];
        float[] fArray2 = float_.offsets[1];
        float[] fArray3 = float_.offsets[2];
        do {
            object = new StringTokenizer(string.trim());
            ((StringTokenizer)object).nextToken();
            double d = Double.parseDouble(((StringTokenizer)object).nextToken());
            double d2 = Double.parseDouble(((StringTokenizer)object).nextToken());
            int n5 = Math.toIntExact(Math.round((d - object2) / object6));
            int n6 = Math.toIntExact(Math.round((d2 - object4) / object7));
            if (n5 < 0 || n5 >= n) {
                throw new FactoryException(Errors.format((short)166, "x", d, object2, object3));
            }
            if (n6 < 0 || n6 >= n2) {
                throw new FactoryException(Errors.format((short)166, "y", d2, object4, object5));
            }
            int n7 = n6 * n + n5;
            if (!(Double.isNaN(fArray[n7]) && Double.isNaN(fArray2[n7]) && Double.isNaN(fArray3[n7]))) {
                throw new FactoryException(Errors.format((short)164, d + ", " + d2));
            }
            fArray[n7] = -Float.parseFloat(((StringTokenizer)object).nextToken());
            fArray2[n7] = -Float.parseFloat(((StringTokenizer)object).nextToken());
            fArray3[n7] = -Float.parseFloat(((StringTokenizer)object).nextToken());
            double d3 = ACCURACY[Math.min(ACCURACY.length - 1, Math.max(0, Integer.parseInt(((StringTokenizer)object).nextToken()) - 1))];
            if (d3 >= float_.accuracy) continue;
            float_.accuracy = d3;
        } while ((string = bufferedReader.readLine()) != null);
        return float_;
    }

    static {
        ParameterBuilder parameterBuilder = FranceGeocentricInterpolation.builder();
        FILE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8727")).addName("Geocentric translation file")).create(Path.class, Paths.get(DEFAULT, new String[0]));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("9655")).addName("France geocentric interpolation")).createGroup(new GeneralParameterDescriptor[]{Molodensky.DIMENSION, Molodensky.SRC_SEMI_MAJOR, Molodensky.SRC_SEMI_MINOR, Molodensky.TGT_SEMI_MAJOR, Molodensky.TGT_SEMI_MINOR, FILE});
    }
}

