/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.measure.Units;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public final class AxisDirections
extends Static {
    public static final int COMPASS_COUNT = 16;
    public static final int GEOCENTRIC_COUNT = 3;
    public static final int DISPLAY_COUNT = 4;
    private static final int LAST_ORDINAL = AxisDirection.DISPLAY_DOWN.ordinal();
    @UML(identifier="awayFrom", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public static final AxisDirection AWAY_FROM = AxisDirection.valueOf((String)"AWAY_FROM");
    @UML(identifier="clockwise", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public static final AxisDirection CLOCKWISE = AxisDirection.valueOf((String)"CLOCKWISE");
    @UML(identifier="counterClockwise", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public static final AxisDirection COUNTER_CLOCKWISE = AxisDirection.valueOf((String)"COUNTER_CLOCKWISE");
    private static final Map<AxisDirection, AxisDirection> OPPOSITES = new HashMap<AxisDirection, AxisDirection>(20);
    private static final Map<AxisDirection, String> ABBREVIATIONS;
    private static final byte[] DISPLAY_ORDER;

    private static void put(AxisDirection axisDirection, AxisDirection axisDirection2) {
        OPPOSITES.put(axisDirection, axisDirection2);
        OPPOSITES.put(axisDirection2, axisDirection);
    }

    private AxisDirections() {
    }

    public static AxisDirection absolute(AxisDirection axisDirection) {
        AxisDirection axisDirection2 = AxisDirections.opposite(axisDirection);
        if (axisDirection2 != null) {
            if (axisDirection2.ordinal() < axisDirection.ordinal()) {
                axisDirection = axisDirection2;
            }
            if (axisDirection == CLOCKWISE) {
                axisDirection = COUNTER_CLOCKWISE;
            }
        }
        return axisDirection;
    }

    public static AxisDirection opposite(AxisDirection axisDirection) {
        return OPPOSITES.get(axisDirection);
    }

    public static boolean isOpposite(AxisDirection axisDirection) {
        AxisDirection axisDirection2 = AxisDirections.opposite(axisDirection);
        return axisDirection2 != null && axisDirection2.ordinal() < axisDirection.ordinal();
    }

    public static boolean isCompass(AxisDirection axisDirection) {
        if (axisDirection == null) {
            return false;
        }
        int n = axisDirection.ordinal() - AxisDirection.NORTH.ordinal();
        return n >= 0 && n < 16;
    }

    public static boolean isCardinal(AxisDirection axisDirection) {
        if (axisDirection == null) {
            return false;
        }
        int n = axisDirection.ordinal() - AxisDirection.NORTH.ordinal();
        return n >= 0 && n < 16 && (n & 3) == 0;
    }

    public static boolean isIntercardinal(AxisDirection axisDirection) {
        if (axisDirection == null) {
            return false;
        }
        int n = axisDirection.ordinal() - AxisDirection.NORTH.ordinal();
        return n >= 0 && n < 16 && (n & 3) != 0;
    }

    public static boolean isVertical(AxisDirection axisDirection) {
        if (axisDirection == null) {
            return false;
        }
        return (axisDirection.ordinal() - AxisDirection.UP.ordinal() & 0xFFFFFFFE) == 0;
    }

    public static boolean isTemporal(AxisDirection axisDirection) {
        if (axisDirection == null) {
            return false;
        }
        return (axisDirection.ordinal() - AxisDirection.FUTURE.ordinal() & 0xFFFFFFFE) == 0;
    }

    public static boolean isGeocentric(AxisDirection axisDirection) {
        if (axisDirection == null) {
            return false;
        }
        int n = axisDirection.ordinal();
        return n >= AxisDirection.GEOCENTRIC_X.ordinal() && n <= AxisDirection.GEOCENTRIC_Z.ordinal();
    }

    public static boolean isSpatialOrUserDefined(AxisDirection axisDirection, boolean bl) {
        if (axisDirection == null) {
            return false;
        }
        int n = axisDirection.ordinal();
        return n < AxisDirection.FUTURE.ordinal() || n > (bl ? AxisDirection.PAST : AxisDirection.DISPLAY_DOWN).ordinal();
    }

    public static boolean isUserDefined(AxisDirection axisDirection) {
        return axisDirection != null && axisDirection.ordinal() > LAST_ORDINAL;
    }

    public static boolean isGrid(AxisDirection axisDirection) {
        if (axisDirection == null) {
            return false;
        }
        int n = axisDirection.ordinal();
        return n >= AxisDirection.COLUMN_POSITIVE.ordinal() && n <= AxisDirection.ROW_NEGATIVE.ordinal();
    }

    public static int angleForGeocentric(AxisDirection axisDirection, AxisDirection axisDirection2) {
        int n;
        int n2 = AxisDirection.GEOCENTRIC_X.ordinal();
        int n3 = axisDirection.ordinal() - n2;
        if (n3 >= 0 && n3 < 3 && (n = axisDirection2.ordinal() - n2) >= 0 && n < 3) {
            int n4 = n - n3;
            n4 -= 3 * (n4 / 2);
            return n4;
        }
        return Integer.MIN_VALUE;
    }

    public static int angleForCompass(AxisDirection axisDirection, AxisDirection axisDirection2) {
        int n;
        int n2 = AxisDirection.NORTH.ordinal();
        int n3 = axisDirection.ordinal() - n2;
        if (n3 >= 0 && n3 < 16 && (n = axisDirection2.ordinal() - n2) >= 0 && n < 16) {
            int n4 = n3 - n;
            if (n4 < -8) {
                n4 += 16;
            } else if (n4 > 8) {
                n4 -= 16;
            }
            return n4;
        }
        return Integer.MIN_VALUE;
    }

    public static int angleForDisplay(AxisDirection axisDirection, AxisDirection axisDirection2) {
        int n;
        int n2 = AxisDirection.DISPLAY_RIGHT.ordinal();
        int n3 = axisDirection.ordinal() - n2;
        if (n3 >= 0 && n3 < 4 && (n = axisDirection2.ordinal() - n2) >= 0 && n < 4) {
            int n4 = (n3 = DISPLAY_ORDER[n3]) - (n = DISPLAY_ORDER[n]);
            if (n4 < -2) {
                n4 += 4;
            } else if (n4 > 2) {
                n4 -= 4;
            }
            return n4;
        }
        return Integer.MIN_VALUE;
    }

    public static Unit<Angle> getAngularUnit(CoordinateSystem coordinateSystem, Unit<Angle> unit) {
        if (coordinateSystem != null) {
            int n = coordinateSystem.getDimension();
            while (--n >= 0) {
                Unit unit2;
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n);
                if (coordinateSystemAxis == null || !Units.isAngular(unit2 = coordinateSystemAxis.getUnit())) continue;
                unit = unit2.asType(Angle.class);
                if (!AxisDirection.EAST.equals((Object)AxisDirections.absolute(coordinateSystemAxis.getDirection()))) continue;
                break;
            }
        }
        return unit;
    }

    public static int indexOfColinear(CoordinateSystem coordinateSystem, AxisDirection axisDirection) {
        int n = -1;
        if (coordinateSystem != null) {
            int n2 = coordinateSystem.getDimension();
            for (int i = 0; i < n2; ++i) {
                AxisDirection axisDirection2 = coordinateSystem.getAxis(i).getDirection();
                if (axisDirection.equals((Object)axisDirection2)) {
                    return i;
                }
                if (n >= 0 || !axisDirection2.equals((Object)AxisDirections.opposite(axisDirection))) continue;
                n = i;
            }
        }
        return n;
    }

    public static int indexOfColinear(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) {
        int n = -1;
        if (coordinateSystem != null) {
            boolean bl = false;
            int n2 = coordinateSystem2.getDimension();
            int n3 = coordinateSystem.getDimension() - n2;
            block0: for (int i = 0; i <= n3; ++i) {
                boolean bl2 = true;
                boolean bl3 = true;
                for (int j = 0; j < n2; ++j) {
                    CoordinateSystemAxis coordinateSystemAxis = coordinateSystem2.getAxis(j);
                    CoordinateSystemAxis coordinateSystemAxis2 = coordinateSystem.getAxis(i + j);
                    if (!AxisDirections.isColinear(coordinateSystemAxis.getDirection(), coordinateSystemAxis2.getDirection())) continue block0;
                    if (bl2 && (bl2 = Utilities.deepEquals(coordinateSystemAxis, coordinateSystemAxis2, ComparisonMode.BY_CONTRACT)) || !bl3) continue;
                    bl3 = NameToIdentifier.isHeuristicMatchForName((IdentifiedObject)coordinateSystemAxis2, coordinateSystemAxis.getName().getCode());
                }
                if (bl2) {
                    return i;
                }
                if (!(n < 0 | bl3 & !bl)) continue;
                bl = bl3;
                n = i;
            }
        }
        return n;
    }

    public static boolean isColinear(AxisDirection axisDirection, AxisDirection axisDirection2) {
        return Objects.equals(AxisDirections.absolute(axisDirection), AxisDirections.absolute(axisDirection2));
    }

    public static AxisDirection find(String string, AxisDirection[] axisDirectionArray) {
        for (AxisDirection axisDirection : axisDirectionArray) {
            String string2 = axisDirection.name();
            if (!CharSequences.equalsFiltered(string, string2, Characters.Filter.LETTERS_AND_DIGITS, true) && !CharSequences.isAcronymForWords(string, string2)) continue;
            return axisDirection;
        }
        return null;
    }

    public static AxisDirection valueOf(String string) {
        int n;
        AxisDirection[] axisDirectionArray;
        AxisDirection axisDirection = AxisDirections.find(string = CharSequences.trimWhitespaces(string.replace('_', ' ')), axisDirectionArray = AxisDirection.values());
        if (axisDirection == null && (n = string.indexOf(62)) >= 0 && AxisDirections.equalsIgnoreCase(string, 0, CharSequences.skipTrailingWhitespaces(string, 0, n), "Geocentre")) {
            int n2 = string.length();
            int n3 = string.indexOf(47, n = CharSequences.skipLeadingWhitespaces(string, n + 1, n2));
            if (n3 < 0) {
                if (AxisDirections.equalsIgnoreCase(string, n, n2, "north pole")) {
                    return AxisDirection.GEOCENTRIC_Z;
                }
            } else if (AxisDirections.equalsIgnoreCase(string, n, CharSequences.skipTrailingWhitespaces(string, n, n3), "equator")) {
                if (AxisDirections.equalsIgnoreCase(string, n3 = CharSequences.skipLeadingWhitespaces(string, n3 + 1, n2), n2, "PM")) {
                    return AxisDirection.GEOCENTRIC_X;
                }
                int n4 = Math.min(n3 + 6, n2);
                for (int i = n3; i < n4; ++i) {
                    char c = string.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    if (i == n3) break;
                    int n5 = Integer.parseInt(string.substring(n3, i));
                    if (!AxisDirections.equalsIgnoreCase(string, i = CharSequences.skipLeadingWhitespaces(string, i, n2), n2, "\u00b0E") && !AxisDirections.equalsIgnoreCase(string, i, n2, "dE")) break;
                    switch (n5) {
                        case 0: {
                            return AxisDirection.GEOCENTRIC_X;
                        }
                        case 90: {
                            return AxisDirection.GEOCENTRIC_Y;
                        }
                    }
                    break;
                }
            }
        }
        return axisDirection;
    }

    private static boolean equalsIgnoreCase(String string, int n, int n2, String string2) {
        int n3 = n2 - n;
        return n3 == string2.length() && string.regionMatches(true, n, string2, 0, n3);
    }

    private static boolean contains(String string, String string2, boolean bl) {
        int n = string2.length();
        return string.regionMatches(true, bl ? string.length() - n : 0, string2, 0, n);
    }

    public static String suggestAbbreviation(String string, AxisDirection axisDirection, Unit<?> unit) {
        String string2;
        if (string.length() == 1) {
            return string;
        }
        if (AxisDirections.contains(string, "radius", true)) {
            return "r";
        }
        if (AxisDirections.isCompass(axisDirection)) {
            if (!AxisDirections.isIntercardinal(axisDirection) && Units.isAngular(unit)) {
                if (AxisDirections.contains(string, "Spherical", false)) {
                    return AxisDirection.NORTH.equals((Object)AxisDirections.absolute(axisDirection)) ? "\u03a9" : "\u03b8";
                }
                return AxisDirection.NORTH.equals((Object)AxisDirections.absolute(axisDirection)) ? "\u03c6" : "\u03bb";
            }
        } else {
            if (AxisDirection.UP.equals((Object)axisDirection)) {
                if (Units.isAngular(unit)) {
                    return "\u03b1";
                }
                if (AxisDirections.contains(string, "Gravity", false)) {
                    return "H";
                }
                if (AxisDirections.contains(string, "Geocentric", false)) {
                    return "r";
                }
                return "h";
            }
            if (AxisDirection.DOWN.equals((Object)axisDirection)) {
                return "D";
            }
            if (AxisDirections.isGeocentric(axisDirection)) {
                String string3 = axisDirection.name();
                return string3.substring(string3.length() - 1).trim();
            }
            string2 = ABBREVIATIONS.get(AxisDirections.absolute(axisDirection));
            if (string2 != null) {
                return string2;
            }
        }
        return CharSequences.camelCaseToAcronym((string2 = axisDirection.identifier()) != null ? string2 : axisDirection.name()).toString().intern();
    }

    public static AxisDirection fromAbbreviation(char c) {
        AxisDirection axisDirection;
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
        }
        switch (c) {
            default: {
                axisDirection = null;
                break;
            }
            case 'W': {
                axisDirection = AxisDirection.WEST;
                break;
            }
            case 'S': {
                axisDirection = AxisDirection.SOUTH;
                break;
            }
            case 'E': 
            case '\u03b8': 
            case '\u03bb': {
                axisDirection = AxisDirection.EAST;
                break;
            }
            case 'N': 
            case '\u03a9': 
            case '\u03c6': {
                axisDirection = AxisDirection.NORTH;
                break;
            }
            case 'H': 
            case 'R': {
                axisDirection = AxisDirection.UP;
                break;
            }
            case 'D': {
                axisDirection = AxisDirection.DOWN;
                break;
            }
            case 'T': {
                axisDirection = AxisDirection.FUTURE;
            }
        }
        return axisDirection;
    }

    public static String appendTo(StringBuilder stringBuilder, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        String string = ": ";
        for (CoordinateSystemAxis coordinateSystemAxis : coordinateSystemAxisArray) {
            String string2;
            stringBuilder.append(string).append(Types.getCodeLabel(coordinateSystemAxis.getDirection()));
            string = ", ";
            Unit unit = coordinateSystemAxis.getUnit();
            if (unit == null || (string2 = unit.toString()) == null || string2.isEmpty()) continue;
            stringBuilder.append(" (").append(string2).append(')');
        }
        return stringBuilder.append('.').toString();
    }

    static {
        AxisDirections.put(AxisDirection.OTHER, AxisDirection.OTHER);
        AxisDirections.put(AxisDirection.NORTH, AxisDirection.SOUTH);
        AxisDirections.put(AxisDirection.NORTH_NORTH_EAST, AxisDirection.SOUTH_SOUTH_WEST);
        AxisDirections.put(AxisDirection.NORTH_EAST, AxisDirection.SOUTH_WEST);
        AxisDirections.put(AxisDirection.EAST_NORTH_EAST, AxisDirection.WEST_SOUTH_WEST);
        AxisDirections.put(AxisDirection.EAST, AxisDirection.WEST);
        AxisDirections.put(AxisDirection.EAST_SOUTH_EAST, AxisDirection.WEST_NORTH_WEST);
        AxisDirections.put(AxisDirection.SOUTH_EAST, AxisDirection.NORTH_WEST);
        AxisDirections.put(AxisDirection.SOUTH_SOUTH_EAST, AxisDirection.NORTH_NORTH_WEST);
        AxisDirections.put(AxisDirection.UP, AxisDirection.DOWN);
        AxisDirections.put(AxisDirection.FUTURE, AxisDirection.PAST);
        AxisDirections.put(AxisDirection.COLUMN_POSITIVE, AxisDirection.COLUMN_NEGATIVE);
        AxisDirections.put(AxisDirection.ROW_POSITIVE, AxisDirection.ROW_NEGATIVE);
        AxisDirections.put(AxisDirection.DISPLAY_RIGHT, AxisDirection.DISPLAY_LEFT);
        AxisDirections.put(AxisDirection.DISPLAY_UP, AxisDirection.DISPLAY_DOWN);
        AxisDirections.put(COUNTER_CLOCKWISE, CLOCKWISE);
        Map<AxisDirection, String> map = ABBREVIATIONS = new HashMap<AxisDirection, String>(12);
        map.put(AxisDirection.FUTURE, "t");
        map.put(AxisDirection.COLUMN_POSITIVE, "i");
        map.put(AxisDirection.ROW_POSITIVE, "j");
        map.put(AxisDirection.DISPLAY_RIGHT, "x");
        map.put(AxisDirection.DISPLAY_UP, "y");
        map.put(AxisDirection.OTHER, "z");
        map.put(AWAY_FROM, "r");
        map.put(COUNTER_CLOCKWISE, "\u03b8");
        DISPLAY_ORDER = new byte[]{1, 3, 0, 2};
    }
}

