/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.distance;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.measure.Longitude;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.GeodeticCalculator;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Deprecated
public class LatLonPointRadius {
    private final DirectPosition center;
    private final double radius;

    public LatLonPointRadius(DirectPosition directPosition, double d) {
        this.center = directPosition;
        this.radius = d;
    }

    public DirectPosition2D[] getCircularRegionApproximation(int n) {
        if (this.radius >= 20037.58) {
            DirectPosition2D[] directPosition2DArray;
            directPosition2DArray = new DirectPosition2D[]{new DirectPosition2D(-180.0, -90.0), new DirectPosition2D(-180.0, 90.0), new DirectPosition2D(180.0, 90.0), new DirectPosition2D(180.0, -90.0), directPosition2DArray[0]};
            return directPosition2DArray;
        }
        DirectPosition2D[] directPosition2DArray = new DirectPosition2D[n + 1];
        double d = 0.0;
        if (n > 0) {
            d = 360 / n;
        }
        GeodeticCalculator geodeticCalculator = GeodeticCalculator.create((CoordinateReferenceSystem)CommonCRS.SPHERE.geographic());
        geodeticCalculator.setStartGeographicPoint(this.center.getOrdinate(1), this.center.getOrdinate(0));
        geodeticCalculator.setGeodesicDistance(this.radius);
        for (int i = 0; i < n; ++i) {
            geodeticCalculator.setStartingAzimuth((double)i * d);
            DirectPosition directPosition = geodeticCalculator.getEndPoint();
            directPosition2DArray[i] = new DirectPosition2D(directPosition.getOrdinate(1), directPosition.getOrdinate(0));
        }
        directPosition2DArray[n] = directPosition2DArray[0];
        return directPosition2DArray;
    }

    public Rectangle2D getRectangularRegionApproximation(int n) {
        Object object;
        if (this.radius >= 20037.58) {
            return new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0);
        }
        int n2 = 0;
        GeodeticCalculator geodeticCalculator = GeodeticCalculator.create((CoordinateReferenceSystem)CommonCRS.SPHERE.geographic());
        geodeticCalculator.setStartGeographicPoint(this.center.getOrdinate(1), this.center.getOrdinate(0));
        Path2D.Double double_ = new Path2D.Double();
        double d = Double.NaN;
        double d2 = Double.NaN;
        geodeticCalculator.setGeodesicDistance(this.radius);
        for (int i = 0; i < 360; ++i) {
            geodeticCalculator.setStartingAzimuth(i);
            object = geodeticCalculator.getEndPoint();
            double d3 = object.getOrdinate(1) + 180.0;
            double d4 = object.getOrdinate(0) + 90.0;
            if (i == 0) {
                d = Longitude.normalize(d3);
                ((Path2D)double_).moveTo(d3, d4);
                continue;
            }
            ((Path2D)double_).lineTo(d3, d4);
            double d5 = d2;
            d2 = Longitude.normalize(d3);
            if (!LatLonPointRadius.dateLineCrossOver(d5, d2)) continue;
            ++n2;
        }
        if (LatLonPointRadius.dateLineCrossOver(d2, d)) {
            ++n2;
        }
        if (n2 == 1) {
            Rectangle2D rectangle2D = double_.getBounds2D();
            object = new Rectangle2D.Double(0.0, 0.0, 360.0, rectangle2D.getMaxY());
            if (((Rectangle2D)object).contains(this.center.getOrdinate(0) + 180.0, this.center.getOrdinate(1) + 90.0)) {
                return object;
            }
            return new Rectangle2D.Double(0.0, rectangle2D.getMinY(), 360.0, 180.0 - rectangle2D.getMinY());
        }
        if (double_.contains(this.center.getOrdinate(0) + 180.0, this.center.getOrdinate(1) + 90.0)) {
            Rectangle2D rectangle2D = double_.getBounds2D();
            if (rectangle2D.getMaxX() - rectangle2D.getMinX() > 359.0) {
                return new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0);
            }
            if (rectangle2D.getMinX() < 0.0 || rectangle2D.getMaxX() > 360.0) {
                return new Rectangle2D.Double(0.0, rectangle2D.getY(), 360.0, rectangle2D.getHeight());
            }
            return double_.getBounds2D();
        }
        Area area = new Area(double_);
        object = new Area(new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0));
        ((Area)object).subtract(area);
        return ((Area)object).getBounds2D();
    }

    private static boolean dateLineCrossOver(double d, double d2) {
        return Math.abs(d - d2) > 180.0;
    }
}

