@REM ----------------------------------------------------------------------------
@REM  Copyright 2001-2006 The Apache Software Foundation.
@REM
@REM  Licensed under the Apache License, Version 2.0 (the "License");
@REM  you may not use this file except in compliance with the License.
@REM  You may obtain a copy of the License at
@REM
@REM       http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM  Unless required by applicable law or agreed to in writing, software
@REM  distributed under the License is distributed on an "AS IS" BASIS,
@REM  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM  See the License for the specific language governing permissions and
@REM  limitations under the License.
@REM ----------------------------------------------------------------------------
@REM
@REM   Copyright (c) 2001-2006 The Apache Software Foundation.  All rights
@REM   reserved.

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup
set REPO=


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\lib

set CLASSPATH="%BASEDIR%"\conf;"%REPO%"\apache-any23-api-2.3.jar;"%REPO%"\apache-any23-core-2.3.jar;"%REPO%"\biweekly-0.6.3.jar;"%REPO%"\vinnie-2.0.2.jar;"%REPO%"\rdf4j-rio-languages-2.4.4.jar;"%REPO%"\rdf4j-rio-datatypes-2.4.4.jar;"%REPO%"\rdf4j-rio-binary-2.4.4.jar;"%REPO%"\rdf4j-rio-n3-2.4.4.jar;"%REPO%"\rdf4j-rio-nquads-2.4.4.jar;"%REPO%"\rdf4j-rio-rdfjson-2.4.4.jar;"%REPO%"\rdf4j-rio-trig-2.4.4.jar;"%REPO%"\owlapi-rio-5.1.9.jar;"%REPO%"\hppcrt-0.7.5.jar;"%REPO%"\caffeine-2.6.1.jar;"%REPO%"\guava-22.0.jar;"%REPO%"\error_prone_annotations-2.0.18.jar;"%REPO%"\j2objc-annotations-1.1.jar;"%REPO%"\animal-sniffer-annotations-1.14.jar;"%REPO%"\jsr305-3.0.2.jar;"%REPO%"\owlapi-parsers-5.1.9.jar;"%REPO%"\owlapi-api-5.1.9.jar;"%REPO%"\commons-rdf-api-0.5.0.jar;"%REPO%"\javax.inject-1.jar;"%REPO%"\owlapi-apibinding-5.1.9.jar;"%REPO%"\owlapi-impl-5.1.9.jar;"%REPO%"\owlapi-oboformat-5.1.9.jar;"%REPO%"\owlapi-tools-5.1.9.jar;"%REPO%"\snakeyaml-1.23.jar;"%REPO%"\xercesImpl-2.12.0.jar;"%REPO%"\xml-apis-1.4.01.jar;"%REPO%"\apache-any23-csvutils-2.3.jar;"%REPO%"\apache-any23-mime-2.3.jar;"%REPO%"\apache-any23-encoding-2.3.jar;"%REPO%"\f8-1.1.jar;"%REPO%"\apache-any23-office-scraper-2.3.jar;"%REPO%"\apache-any23-html-scraper-2.3.jar;"%REPO%"\nekohtml-1.9.22.jar;"%REPO%"\boilerpipe-1.1.0.jar;"%REPO%"\commons-lang-2.6.jar;"%REPO%"\httpclient-4.5.7.jar;"%REPO%"\httpcore-4.4.11.jar;"%REPO%"\commons-codec-1.11.jar;"%REPO%"\jcommander-1.72.jar;"%REPO%"\tika-core-1.20.jar;"%REPO%"\tika-parsers-1.20.jar;"%REPO%"\jaxb-runtime-2.3.1.jar;"%REPO%"\jaxb-api-2.3.1.jar;"%REPO%"\txw2-2.3.1.jar;"%REPO%"\istack-commons-runtime-3.0.7.jar;"%REPO%"\stax-ex-1.8.jar;"%REPO%"\FastInfoset-1.2.15.jar;"%REPO%"\javax.activation-1.2.0.jar;"%REPO%"\commons-lang3-3.8.1.jar;"%REPO%"\javax.annotation-api-1.3.2.jar;"%REPO%"\vorbis-java-tika-0.8.jar;"%REPO%"\jmatio-1.5.jar;"%REPO%"\apache-mime4j-core-0.8.2.jar;"%REPO%"\apache-mime4j-dom-0.8.2.jar;"%REPO%"\xz-1.8.jar;"%REPO%"\parso-2.0.10.jar;"%REPO%"\dec-0.1.2.jar;"%REPO%"\pdfbox-2.0.13.jar;"%REPO%"\fontbox-2.0.13.jar;"%REPO%"\pdfbox-tools-2.0.13.jar;"%REPO%"\jempbox-1.8.16.jar;"%REPO%"\bcmail-jdk15on-1.60.jar;"%REPO%"\bcpkix-jdk15on-1.60.jar;"%REPO%"\bcprov-jdk15on-1.60.jar;"%REPO%"\jackcess-2.1.12.jar;"%REPO%"\jackcess-encrypt-2.1.4.jar;"%REPO%"\tagsoup-1.2.1.jar;"%REPO%"\asm-7.0.jar;"%REPO%"\isoparser-1.1.22.jar;"%REPO%"\metadata-extractor-2.11.0.jar;"%REPO%"\xmpcore-5.1.3.jar;"%REPO%"\rome-1.12.0.jar;"%REPO%"\rome-utils-1.12.0.jar;"%REPO%"\vorbis-java-core-0.8.jar;"%REPO%"\juniversalchardet-1.0.3.jar;"%REPO%"\jhighlight-1.0.3.jar;"%REPO%"\java-libpst-0.8.1.jar;"%REPO%"\junrar-2.0.0.jar;"%REPO%"\cxf-rt-rs-client-3.2.7.jar;"%REPO%"\cxf-rt-transports-http-3.2.7.jar;"%REPO%"\cxf-core-3.2.7.jar;"%REPO%"\woodstox-core-5.0.3.jar;"%REPO%"\stax2-api-3.1.4.jar;"%REPO%"\xmlschema-core-2.2.3.jar;"%REPO%"\cxf-rt-frontend-jaxrs-3.2.7.jar;"%REPO%"\javax.ws.rs-api-2.1.1.jar;"%REPO%"\commons-exec-1.3.jar;"%REPO%"\opennlp-tools-1.9.0.jar;"%REPO%"\json-simple-1.1.1.jar;"%REPO%"\openjson-1.0.10.jar;"%REPO%"\gson-2.8.5.jar;"%REPO%"\netcdf4-4.5.5.jar;"%REPO%"\jcip-annotations-1.0.jar;"%REPO%"\grib-4.5.5.jar;"%REPO%"\protobuf-java-2.5.0.jar;"%REPO%"\bzip2-0.9.1.jar;"%REPO%"\jna-5.1.0.jar;"%REPO%"\cdm-4.5.5.jar;"%REPO%"\udunits-4.5.5.jar;"%REPO%"\joda-time-2.2.jar;"%REPO%"\quartz-2.2.0.jar;"%REPO%"\c3p0-0.9.1.1.jar;"%REPO%"\ehcache-core-2.6.2.jar;"%REPO%"\httpservices-4.5.5.jar;"%REPO%"\sis-utility-0.8.jar;"%REPO%"\unit-api-1.0.jar;"%REPO%"\sis-netcdf-0.8.jar;"%REPO%"\sis-storage-0.8.jar;"%REPO%"\sis-feature-0.8.jar;"%REPO%"\sis-referencing-0.8.jar;"%REPO%"\sis-metadata-0.8.jar;"%REPO%"\geoapi-3.0.1.jar;"%REPO%"\sentiment-analysis-parser-0.1.jar;"%REPO%"\uimafit-core-2.4.0.jar;"%REPO%"\uimaj-core-3.0.1.jar;"%REPO%"\procyon-compilertools-0.5.32.jar;"%REPO%"\procyon-core-0.5.32.jar;"%REPO%"\jdom2-2.0.6.jar;"%REPO%"\jbig2-imageio-3.0.2.jar;"%REPO%"\jai-imageio-core-1.4.0.jar;"%REPO%"\jackson-core-2.9.8.jar;"%REPO%"\jackson-databind-2.9.8.jar;"%REPO%"\jackson-annotations-2.9.8.jar;"%REPO%"\rdf4j-model-2.4.4.jar;"%REPO%"\rdf4j-util-2.4.4.jar;"%REPO%"\rdf4j-rio-api-2.4.4.jar;"%REPO%"\rdf4j-rio-jsonld-2.4.4.jar;"%REPO%"\rdf4j-rio-turtle-2.4.4.jar;"%REPO%"\rdf4j-rio-rdfxml-2.4.4.jar;"%REPO%"\rdf4j-rio-ntriples-2.4.4.jar;"%REPO%"\rdf4j-rio-trix-2.4.4.jar;"%REPO%"\rdf4j-repository-sail-2.4.4.jar;"%REPO%"\rdf4j-sail-api-2.4.4.jar;"%REPO%"\rdf4j-http-client-2.4.4.jar;"%REPO%"\rdf4j-http-protocol-2.4.4.jar;"%REPO%"\rdf4j-queryresultio-api-2.4.4.jar;"%REPO%"\rdf4j-queryparser-api-2.4.4.jar;"%REPO%"\rdf4j-queryalgebra-model-2.4.4.jar;"%REPO%"\rdf4j-query-2.4.4.jar;"%REPO%"\rdf4j-queryalgebra-evaluation-2.4.4.jar;"%REPO%"\rdf4j-repository-sparql-2.4.4.jar;"%REPO%"\rdf4j-queryparser-sparql-2.4.4.jar;"%REPO%"\rdf4j-queryresultio-sparqlxml-2.4.4.jar;"%REPO%"\mapdb-1.0.8.jar;"%REPO%"\rdf4j-sail-memory-2.4.4.jar;"%REPO%"\rdf4j-sail-base-2.4.4.jar;"%REPO%"\rdf4j-sail-inferencer-2.4.4.jar;"%REPO%"\rdf4j-queryparser-serql-2.4.4.jar;"%REPO%"\rdf4j-sail-model-2.4.4.jar;"%REPO%"\rdf4j-repository-api-2.4.4.jar;"%REPO%"\jsonld-java-0.12.3.jar;"%REPO%"\semargl-rdf4j-0.7.jar;"%REPO%"\semargl-core-0.7.jar;"%REPO%"\semargl-rdfa-0.7.jar;"%REPO%"\semargl-rdf-0.7.jar;"%REPO%"\commons-csv-1.6.jar;"%REPO%"\slf4j-log4j12-1.7.25.jar;"%REPO%"\log4j-1.2.17.jar;"%REPO%"\httpmime-4.5.7.jar;"%REPO%"\httpclient-cache-4.5.7.jar;"%REPO%"\commons-compress-1.18.jar;"%REPO%"\commons-io-2.6.jar;"%REPO%"\jsoup-1.11.3.jar;"%REPO%"\slf4j-api-1.7.25.jar;"%REPO%"\jcl-over-slf4j-1.7.25.jar;"%REPO%"\jul-to-slf4j-1.7.25.jar;"%REPO%"\poi-4.0.1.jar;"%REPO%"\commons-collections4-4.2.jar;"%REPO%"\commons-math3-3.6.1.jar;"%REPO%"\poi-scratchpad-4.0.1.jar;"%REPO%"\poi-ooxml-4.0.1.jar;"%REPO%"\poi-ooxml-schemas-4.0.1.jar;"%REPO%"\xmlbeans-3.0.2.jar;"%REPO%"\curvesapi-1.05.jar;"%REPO%"\apache-any23-cli-2.3.jar

set ENDORSED_DIR=
if NOT "%ENDORSED_DIR%" == "" set CLASSPATH="%BASEDIR%"\%ENDORSED_DIR%\*;%CLASSPATH%

if NOT "%CLASSPATH_PREFIX%" == "" set CLASSPATH=%CLASSPATH_PREFIX%;%CLASSPATH%

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS% -Xmx6000m -classpath %CLASSPATH% -Dapp.name="any23" -Dapp.repo="%REPO%" -Dapp.home="%BASEDIR%" -Dbasedir="%BASEDIR%" org.apache.any23.cli.ToolRunner %CMD_LINE_ARGS%
if %ERRORLEVEL% NEQ 0 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=%ERRORLEVEL%

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@REM If error code is set to 1 then the endlocal was done already in :error.
if %ERROR_CODE% EQU 0 @endlocal


:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
