/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util.com.google.ical.values;

import biweekly.util.com.google.ical.values.DateValue;
import biweekly.util.com.google.ical.values.TimeValue;

public class DateValueImpl
implements DateValue {
    private final int year;
    private final int month;
    private final int day;

    public DateValueImpl(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public int year() {
        return this.year;
    }

    public int month() {
        return this.month;
    }

    public int day() {
        return this.day;
    }

    public String toString() {
        return String.format("%04d%02d%02d", this.year, this.month, this.day);
    }

    public final int compareTo(DateValue other) {
        int n1;
        int n0 = this.day() + (this.month() << 5) + (this.year() << 9);
        if (n0 != (n1 = other.day() + (other.month() << 5) + (other.year() << 9))) {
            return n0 - n1;
        }
        if (!(this instanceof TimeValue)) {
            return other instanceof TimeValue ? -1 : 0;
        }
        TimeValue self = (TimeValue)((Object)this);
        if (!(other instanceof TimeValue)) {
            return 1;
        }
        TimeValue othr = (TimeValue)((Object)other);
        int m0 = self.second() + (self.minute() << 6) + (self.hour() << 12);
        int m1 = othr.second() + (othr.minute() << 6) + (othr.hour() << 12);
        return m0 - m1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateValue)) {
            return false;
        }
        return this.compareTo((DateValue)o) == 0;
    }

    public int hashCode() {
        return (this.year() << 9) + (this.month() << 5) + this.day();
    }
}

